/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;

/**
 * ADD_EMPTY܂߂āA΂us܂B
 * ݂̃m[hMoveɑPropertyĂꍇA
 * ̃m[h̒ɋ̃m[hǉāAɐ΂u܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class SetStone extends Command4NodeList {
	/** u{0}̔zuv */
	static private final MessageResource LB_NAME 
		= new MessageResource(SetStone.class, "lbName"); //$NON-NLS-1$

	
	private final SgfPoint point_;
	private final SgfColor color_;
	
	/**  */
	private Command4NodeList actualCommand_;
	private int nodeIndex_;

	/**
	 * pointcolorŎw肳ꂽ΂pointɒu܂B<br>
	 * colornull̏ꍇ́Apointɂ΂폜ƂɂȂ܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException nodelist, pointnull̏ꍇ
	 * @throws IllegalArgumentException nodeIndex̒lnodeList̃TCY𒴂ĂꍇB
	 */
	public SetStone(SgfPoint point, SgfColor color) {
		super();
	    ArgumentChecker.throwIfNull(point);
        if(point.condition().equals(SgfPointType.PASS)) {
            throw new IllegalArgumentException("Set stone command dosen't permit PASS point"); //$NON-NLS-1$
        }		

        point_ = point;
		color_ = color;
		setDisplayName(LB_NAME.get(getSetupType(color_).displayName()));
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#setup()
	 */
	@Override
	protected boolean setup() {
		if (actualCommand_ != null) {
			return true;
		}
		EditableNodeList nodeList_ = getEditableNodeList();
		if (nodeList_ == null) {
			return false;
		}

		nodeIndex_ = nodeList_.getPositionIndex();
		NodeEntity entity = nodeList_.get(nodeIndex_);
		if (entity.getNode().contains(PropertyType.MOVE)) {
			setExecutedNodeIndex(nodeIndex_);
			setUndoneNodeIndex(nodeIndex_);
			actualCommand_ = makeCommandForMove();
		} else {
			setExecutedNodeIndex(nodeIndex_);
			setUndoneNodeIndex(nodeIndex_);
			actualCommand_ = makeCommandForRegular();
		}
		return true;
	}

	/**
	 * ǉ悤Ƃm[hMOVE^̃vpeBꍇ
	 * R}h쐬ĕԂ܂B<br> 
	 * ̏ꍇ݂̒̎OSetupm[hǉ܂B
	 */
	private Command4NodeList makeCommandForMove() {
		Node node = new Node(makeSetupMove(color_));
		Command4NodeList command;
		// InsertNodeł͖ɑ}łȂ̂ŁA
		// nodeIndex_̒lŕ򂵂ĂB
		if (getEditableNodeList().size() == (nodeIndex_ + 1)) {
		    command = new AddNode(node);
		    command.setEditableNodeList(getEditableNodeList());
		} else {
		    command = new InsertNode(getEditableNodeList(), node);
		}
		return command;
	}
	
	/**
	 * ǉ悤Ƃm[hMOVE^̃vpeBȂꍇA
	 * ܂W̔z΃R}h쐬ĕԂ܂B
	 */
	private Command4NodeList makeCommandForRegular() {
        Property addBlack = makeSetupMove(SgfColor.BLACK);
        Property addWhite = makeSetupMove(SgfColor.WHITE);
        Property addEmpty = makeSetupMove(null);

        // ABAAWAAE݂͂ɔrłB
        // Wɂ邻폜Ώۂɂ邽߂Property̔zB
        Property[] forRemoves = new Property[2];
        Property forInsert = makeSetupMove(color_);
        if (SgfColor.BLACK.equals(color_)) {// ΂u
            forRemoves[0] = addWhite;
            forRemoves[1] = addEmpty;
        
        } else if (SgfColor.WHITE.equals(color_)) {// ΂u
            forRemoves[0] = addBlack;
            forRemoves[1] = addEmpty;

        } else {
        	// ΂Bm[hAB,AWꍇ͑݃`FbN
        	// AB,AWPointɂꍇAB,AWɂB
            forRemoves[0] = addBlack;
            forRemoves[1] = addWhite;
            Node node = getEditableNodeList().get(nodeIndex_).getNode();
            for (SgfId sgfId : new SgfId[]{SgfId.ADD_BLACK, SgfId.ADD_WHITE}) {
                Property property = node.getProperty(sgfId);
                if (property == null) {
                	continue;
                }
                for (String string : property.getStrings()) {
                	if (string.equals(point_.getString())) {
                		forInsert = null;
                		break;
                	}
                }
            	
            }
        }
	    
	    UpdateProperty command = new UpdateProperty(forRemoves, forInsert, null);
	    command.setEditableNodeList(getEditableNodeList());
	    return command;
	}
	
	/**
	 * colorɑΉAB,AW,AẼvpeB쐬ĕԂ܂B
	 * W{@link #point_}łB
	 */
	private Property makeSetupMove(SgfColor color) {
	    Property property = new Property();
        property.setId(getSetupType(color).id());
        property.addValue(new Value(point_.getString()));
        return property;
	}

	/**
	 * colorɑΉAB,AW,AĚ^Ԃ܂Bcolornull̏ꍇAEԂ܂B
	 */
	private SgfId getSetupType(SgfColor color) {
        if (SgfColor.BLACK.equals(color)) {// ΂u
            return SgfId.ADD_BLACK;
        
        } else if (SgfColor.WHITE.equals(color)) {// ΂u
            return SgfId.ADD_WHITE;
        }
        // ΂
        return SgfId.ADD_EMPTY;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		actualCommand_.execute();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		actualCommand_.undo();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
	}
}
