/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;

/**
 * Rootm[hVWݒ肵܂B܂łRootłVWݒl͍폜܂B<br>
 * VW͈͕̔͂SĒׂĐ΂͈́{PłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SetVwAtRoot extends Command4NodeList {

	/**
	 * ۂ̃R}hłB
	 */
	private UpdateProperty command_;
	
	private SgfSize sgfSize_;
	
	/**
	 * 
	 */
	public SetVwAtRoot() {
		super();
		command_ = null;
		sgfSize_ = null;
	}


	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#setup()
	 */
	@Override
	protected boolean setup() {
		if (command_ != null) {
			return true;
		}
		if (getEditableNodeList() == null){
			return false;
		}
		
		RootGameTree root = getEditableNodeList().getRoot();
		sgfSize_ = root.getSize();
		List<SgfPoint> allStones = new ArrayList<SgfPoint>(sgfSize_.width() * sgfSize_.height());
		addAllStones(root, allStones);
		Property append;
		if (allStones.isEmpty()) {
			append = null;
		} else {
			SgfRectangle sgfRectangle = SgfRectangle.create(
					allStones.toArray(new SgfPoint[allStones.size()]));
			
			SgfPoint start = sgfRectangle.getStart();
			int sx = (1 < start.x()) ? start.x() - 1 : start.x();
			int sy = (1 < start.y()) ? start.y() - 1 : start.y();
			
			SgfPoint end = sgfRectangle.getEnd();
			int ex = (end.x() < sgfSize_.width()) ? end.x() + 1 : end.x();
			int ey = (end.y() < sgfSize_.height()) ? end.y() + 1 : end.y();
			sgfRectangle.set(SgfPoint.create(sgfSize_,sx,sy), SgfPoint.create(sgfSize_,ex,ey));
			append = new Property(SgfId.VIEW, sgfRectangle.getValue());
		}
		
		Property property = root.getSequence().getFirst().getProperty(SgfId.VIEW);
		Property[] exclude = (property != null) ? new Property[]{property} : new Property[0];
		
		command_ = new UpdateProperty(exclude, append, PropertyType.ROOT);
		command_.setEditableNodeList(getEditableNodeList());
		command_.setExecutedNodeIndex(0);
		command_.setUndoneNodeIndex(getEditableNodeList().getPositionIndex());
		return true;
	}


	/**
	 * @param root
	 * @param allStones
	 */
	private void addAllStones(GameTree gameTree, List<SgfPoint> allStones) {
		for (Node node : gameTree.getSequence()) {
			for (SgfId sgfId : new SgfId[]{SgfId.WHITE, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.ADD_BLACK}) {
				Property property = node.getProperty(sgfId);
				if (property == null) {
					continue;
				}
				allStones.addAll(
						Arrays.asList(SgfPoint.parse(sgfSize_, property.getStrings())));
			}
		}
		
		for (GameTree child : gameTree.getChildren()) {
			addAllStones(child, allStones);
		}
	}


	/* (non-Javadoc)
	 * @see org.unitarou.cmd.AbstractCommand#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		command_.execute();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.AbstractCommand#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		command_.undo();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.ROOT_GAME_TREE, ModelInfluence.NODE_CURRENT);
	}
}