/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;

/**
 * l̖Jnn_{@link #nodeList_}ړR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class StartSolvingProblem extends Command4NodeList {
    static private final MessageResource LB_NAME
    		= new MessageResource(StartSolvingProblem.class, "lbName"); //$NON-NLS-1$

    private final GameMediator gameMediator_;
    /**
     * 
     */
    public StartSolvingProblem(GameMediator gameMediator) {
        super();
        ArgumentChecker.throwIfNull(gameMediator);
        gameMediator_ = gameMediator;
        setUndoneNodeIndex(gameMediator_.getCurrentNodeIndex());
        setDisplayName(LB_NAME.get());
    }

    
    /* (non-Javadoc)
     * @see org.unitarou.cmd.Command#execute()
     */
    @Override
	public void execute() {
        super.execute();
        NodeList nodeList = gameMediator_.getNodeList();
	    for (int i = 0; i < gameMediator_.getNodeList().size(); ++i) {
	        Stone move = nodeList.getNodeView(i).getMove();
	        if (move.getColor() == null) {
	            continue;
	        }
            int nodeIndex = (i != 0) ? i - 1 : 0;
            setExecutedNodeIndex(nodeIndex);
            gameMediator_.setNodeIndex(nodeIndex);
            return;
        }
    }
    /* (non-Javadoc)
     * @see org.unitarou.cmd.Command#undo()
     */
    @Override
	public void undo() {
        super.undo();
		//TODO Kv`FbN(GameMediatorŃ`FbNĂ͂c)
        gameMediator_.setNodeIndex(getUndoneNodeIndex());
    }
    
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		// TODO ۂɂ͎gȂ̂ŁCNXKw𕪂قǂ
		return EnumSet.of(ModelInfluence.NODE_CURRENT);
	}

}
