/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class UnsetVwAtRoot extends Command4NodeList {

	/**
	 * ۂ̃R}hłB
	 */
	private UpdateProperty command_;
	
	/**
	 * 
	 */
	public UnsetVwAtRoot() {
		super();
		command_ = null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#setup()
	 */
	@Override
	protected boolean setup() {
		if (command_ != null) {
			return true;
		}
		if (getEditableNodeList() == null){
			return false;
		}
		
		RootGameTree root = getEditableNodeList().getRoot();
		Property property = root.getSequence().getFirst().getProperty(SgfId.VIEW);
		Property[] exclude = (property != null) ? new Property[]{property} : new Property[0];		
		command_ = new UpdateProperty(exclude, null, PropertyType.ROOT);
		command_.setEditableNodeList(getEditableNodeList());
		command_.setExecutedNodeIndex(0);
		command_.setUndoneNodeIndex(getEditableNodeList().getPositionIndex());		
		return true;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		command_.execute();
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		command_.undo();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.ROOT_GAME_TREE, ModelInfluence.NODE_CURRENT);
	}
}
