/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.cmd.EditProperty;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;

/**
 * {@link org.unitarou.sgf.Property}̍XVsR}hłB
 * 
 * {@link org.unitarou.sgf.cmd.EditProperty#getEditType()}pāA
 * {@link org.unitarou.sgf.cmd.EditProperty#ADD_OR_REPLACE}
 * {@link org.unitarou.sgf.SgfId#displayName()}𗘗păR}h쐬܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class UpdateProperty extends Command4NodeList {
	static private final Log log_s_ = LogFactory.getLog(UpdateProperty.class);

	/** u{0}̒ǉv */
	static private final MessageResource LB_ADD_NAME 
			= new MessageResource(UpdateProperty.class, "lbAddName"); //$NON-NLS-1$

	/** u{0}̕ҏWv */
	static private final MessageResource LB_EDIT_NAME
			= new MessageResource(UpdateProperty.class, "lbEditName"); //$NON-NLS-1$
    
	/** u{0}̍폜v */
	static private final MessageResource LB_DELETE_NAME 
			= new MessageResource(UpdateProperty.class, "lbDeleteName"); //$NON-NLS-1$
	
	private final Property[] excluded_;
	
	/**
	 * ǉEҏWΏۂƂȂPropertyA폜݂̂̏ꍇ<code>null</code>
	 */
	private final Property include_;
	
	private final PropertyType propertyType_;
	private NodeEntity target_;
	private EditProperty[] editProperties_;
	private boolean hasRgtInfluence_;
	private EnumSet<ModelInfluence> influences_;
	
	/**
	 * l邩WGT؂ւɁA
	 * m[hPƓŝłPǉR}hB 
	 */
	private Command addNode_;

	/**
     * ݑIĂNodepointinclude̋Lǉ܂B
     * includenull̏ꍇ͉܂B
     * ɓPointɂexcluded폜܂B
	 * @param excluded 폜ΏۂƂȂProperty̔z
	 * @param include  ǉEҏWΏۂƂȂPropertyA폜݂̂̏ꍇnullOK
     * @param propertyType lw肷ƁÃ݂m[h㗬ɂ̂ڂāA
     *         ŏɂTypem[hɑ΂čXV܂B
     *         Ȃꍇŏʂ̃m[hɍXV܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException excludednull̏ꍇ
	 */
    public UpdateProperty(Property[] excluded, Property include, PropertyType propertyType) {
        super();
        ArgumentChecker.throwIfNull((Object)excluded);

        editProperties_ = null;
        hasRgtInfluence_ = false;
        addNode_ = NullCommand.INSTANCE;
        excluded_ = new Property[excluded.length];
        System.arraycopy(excluded, 0, excluded_, 0, excluded_.length);
        include_ = include;
        propertyType_ = propertyType;
        influences_ = EnumSet.noneOf(ModelInfluence.class);
    }

    /**
	 * {@link Command4NodeList#getEditableNodeList()}
	 * p[^\܂B
	 * \ɐꍇA܂͂łɍ\ĂꍇtrueԂ܂B
	 * @return
	 */
    @Override
	protected boolean setup() {
    	if (editProperties_ != null) {
    		return true;
    	}
    	EditableNodeList nodeList_ = getEditableNodeList();
    	if (nodeList_ == null) {
    		return false;
    	}
        target_ = nodeList_.getPosition();
        // GameInfoȂǂł݂͌̃m[hɃvpeB݂ȂꍇB
        // ̏ꍇ㗬̃m[hɑ΂ČsҏWB
        if (propertyType_ == null) {
        	influences_.add(ModelInfluence.NODE_CURRENT);
        	
        } else {
        	int index = nodeList_.getPositionIndex();
            while (0 <= index) {
                NodeEntity entity = nodeList_.get(index);
                if (entity.getNode().contains(propertyType_)) {
                	target_ = nodeList_.get(index);
                    break;
                }
                --index;
            }
            if (propertyType_.equals(PropertyType.ROOT) && index != 0) { 
            	assert false : "Bad strucuture."; //$NON-NLS-1$
            }
            
            switch (propertyType_) {
			case GAME_INFO:
				influences_.add(ModelInfluence.NODE_GAMEINFO);
				break;
				
			case ROOT:
				influences_.add(ModelInfluence.ROOT_GAME_TREE);
				break;
				
			default:
				int delta = index - nodeList_.getPositionIndex();
				if (delta == 0) {
					influences_.add(ModelInfluence.NODE_CURRENT);
				} else {
					log_s_.warn("Unsupported update type: index - curIndex:" + delta); //$NON-NLS-1$
				}
				break;
			}
        }
        
        // ΂΂̏Ԃ̈PropertỷɂB
		// EǉEւProperty 
		// E폜Property
	    List<EditProperty> commands = new ArrayList<EditProperty>(excluded_.length + 1);
	    if (include_ == null) {
		    String deleteTypeName = composeDeleteCommandName(target_, excluded_);
		    if (!deleteTypeName.equals(Strings.EMPTY)) {
		        setDisplayName(LB_DELETE_NAME.get(deleteTypeName));
		    }
	        
	    } else {
	        if (target_.getNode().contains(include_.sgfId())) {
	            setDisplayName(LB_EDIT_NAME.get(include_.sgfId().displayName()));
	        } else {
	            setDisplayName(LB_ADD_NAME.get(include_.sgfId().displayName()));
	        }
	        commands.add(new EditProperty(target_.getNode(), include_, EditProperty.ADD_OR_REPLACE));
	        if (nodeList_.size() == 1 
	        		&& include_.sgfId().equals(SgfId.GAME_TYPE) 
	        		&& include_.getStrings()[0].equals(GameType.DRILL.getString())) 
	        {
	        	Node node = new Node(
	        			SgfId.PROBLEM_PROPERTIES.makeProperty(new ProblemProperties(0)));
	        	AddNode addNode = new AddNode(node);
	        	addNode.setEditableNodeList(nodeList_);
	        	addNode_ = addNode;
	        }
	    }
	    for (int i = 0; i < excluded_.length; ++i) {
	        commands.add(new EditProperty(target_.getNode(), excluded_[i], EditProperty.DELETE));
	    }
        
        editProperties_ = commands.toArray(new EditProperty[commands.size()]); 
		setExecutedNodeIndex(nodeList_.getPositionIndex());
		setUndoneNodeIndex(nodeList_.getPositionIndex());
    	return true;
    }
    
    /**
     * {@link org.unitarou.sgf.Property}폜ۂ̃[Uɕ\閼̂Ԃ܂B
     * 폜Ȃꍇ{@link Strings#EMPTY}Ԃ܂B
     */
    private String composeDeleteCommandName(NodeEntity target, Property[] excluded) {
	    for (int i = 0; i < excluded.length; ++i) {
	        Property p = target.getNode().getProperty(excluded[i].sgfId());
	        if (p == null){
	            continue;
	        }
	        if (p.sgfId().equals(excluded[i].sgfId())) {
	            return excluded[i].sgfId().displayName();
	        }
	    }
	    return Strings.EMPTY;
    }


    /* (non-Javadoc)
     * @see org.unitarou.cmd.Command#execute()
     */
    @Override
	public void execute() {
		super.execute();
		Set<SgfId> updateIds = new HashSet<SgfId>(editProperties_.length);
        for (EditProperty editProperty : editProperties_) {
        	editProperty.execute();
        	updateIds.add(editProperty.getSgfId());
        }
        addNode_.execute();
        hasRgtInfluence_ = getEditableNodeList().refresh(updateIds);
        if (!hasRgtInfluence_) {
        	target_.update();
        }
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.cmd.Command#undo()
     */
    @Override
	public void undo() {
		super.undo();
        addNode_.undo();
		Set<SgfId> updateIds = new HashSet<SgfId>(editProperties_.length);
        for (EditProperty editProperty : editProperties_) {
        	editProperty.undo();
        	updateIds.add(editProperty.getSgfId());
        }
        hasRgtInfluence_ = getEditableNodeList().refresh(updateIds);
        if (!hasRgtInfluence_) {
        	target_.update();
        }
    }
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return influences_;
	}
}
