/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import org.unitarou.io.Ios;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ViewerUtils {
	/**uW̊fBNgIv*/
	static public final MessageResource NT_CHOOSE_DRILL_ROOT_DIRECTORY 
			= new MessageResource(ViewerUtils.class, "ntChooseDrillRootDirectory"); //$NON-NLS-1$

	/**
	 * uʓIɂ͑IfBNgȉɋl̃t@C܂B\n
	 * @eł͎̑΃fBNgw肳Ă܂F{0}v
	 */
	static public final MessageResource  MSG_CHOOSE_DRILL_ROOT_DIRECTORY 
			= new MessageResource(ViewerUtils.class, "msgChooseDrillRootDirectory"); //$NON-NLS-1$
	
	/**uDrill.sgfv*/
	static public final MessageResource  NT_AUTO_DRILL_NAME 
			= new MessageResource(ViewerUtils.class, "ntAutoDrillName"); //$NON-NLS-1$	

	/**
	 * collection̐擪{@link GameType#DRILL}
	 * collection{@link Collection#getFile()}󂾂ꍇA
	 * fBNg_CAO\ă[Uw肵tH_̉
	 * _~[t@C쐬܂B[ULZꍇ
	 * JgfBNg{_~[t@Cw肵܂B
	 * @param collection
	 */
	static public void setupDriiRootDirectory(Collection collection) {
		ArgumentChecker.throwIfNull(collection);
		if (!collection.get(0).getGameType().equals(GameType.DRILL)
				 || (collection.getFile() != null)) 
		{
			return;
		}
		
		String[] values = BasicFinder.findData(collection.get(0).getSequence(), SgfId.INPUT_FILES);
		values = (values == null) ? new String[0] : values;
		
		Set<String> pathSet = new HashSet<String>();
		for (String string : values) {
			int endPath = string.lastIndexOf('/');
			if (endPath == -1) {
				pathSet.add("."); //$NON-NLS-1$
			} else {
				pathSet.add(string.substring(0, endPath));
			}
		}
		StringBuilder builder = new StringBuilder();
		for (String path : pathSet) {
			builder.append(path).append(", "); //$NON-NLS-1$
		}
		if (builder.length() != 0) {
			builder.deleteCharAt(builder.length() - 1);
			builder.deleteCharAt(builder.length() - 1);
		}
		File dir = Yukinoshita.application().openDirectoryDialog(
						NT_CHOOSE_DRILL_ROOT_DIRECTORY.get(),
						MSG_CHOOSE_DRILL_ROOT_DIRECTORY.get(builder.toString()),
						Ios.getCurrentDirectory());

		if (dir == null) {
			dir = Ios.getCurrentDirectory();
		}
		dir = new File(dir, NT_AUTO_DRILL_NAME.get()); 
		try {
			dir = Ios.createTemporaryFile(dir, 4);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		collection.setFile(dir);
	}
	/**
	 * 
	 */
	protected ViewerUtils() {
		super();
	}
}
