/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.cmd.CommandDriver.Status;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
abstract public class AbstractCommand4View implements Command4View {
	static private final Log log_s_ = LogFactory.getLog(AbstractCommand4View.class);
	
	
	
	private final ParameterImpl parameter_;

	/**
	 * 
	 */
	public AbstractCommand4View() {
		super();
		parameter_ = new ParameterImpl();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#getParameter()
	 */
	final public Parameter getParameter() {
		return parameter_;
	}

	/**
	 * ݕێĂ{@link CollectionEditor}Ԃ܂B<br>
	 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
	 * @return
	 */
	final protected CollectionEditor getCollectionEditor() {
		return parameter_.collectionEditor_;
	}
	
	/**
	 * ݕێĂ{@link EventBroker}Ԃ܂B<br>
	 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
	 * @return
	 */
	final protected EventBroker getEventBroker() {
		return parameter_.eventBroker_;		
	}
	
	/**
	 * ݂̕ҏWEҏW[h̒lԂ܂B
	 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
	 * @return
	 */
	final protected Boolean isEditMode() {
		return parameter_.isEditMode_;
	}
	
    /**
     * \EҏWRNVŜ̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
     */
    final protected void fireCollectionViewerUpdate() {
    	throwIfNotSetup();
		GameType gameType = parameter_.collectionEditor_.getActiveGame().getGameType();
        parameter_.eventBroker_.connect(gameType, parameter_.isEditMode_.booleanValue());
        for (CollectionMonitor viewer : parameter_.eventBroker_.getListeners(CollectionMonitor.class)) {
        	viewer.update(parameter_.collectionEditor_);
        }
	}

    /**
     * \EҏWQ[̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
     */
	final protected void fireGameViewerUpdate() {
		throwIfNotSetup();
		ViewerUtils.setupDriiRootDirectory(parameter_.collectionEditor_.getCollection());
		GameMediator gameMediator = parameter_.collectionEditor_.getActiveGame();
	    for (GameMonitor gameViewer : parameter_.eventBroker_.getListeners(GameMonitor.class)) {
	    	gameViewer.update(gameMediator);
	    }
	}
	
    /**
     * \EҏWQ[̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
     */
	final protected void fireGameInfoNodeUpdate() {
		throwIfNotSetup();
		GameMediator gameMediator = parameter_.collectionEditor_.getActiveGame();
		
		//GameInfoNodeViewF
		int index = gameMediator.findNodeView(PropertyType.GAME_INFO);
		if (index < 0) {
			index = 0;
		}
		NodeView target = gameMediator.getNodeList().getNodeView(index);
		fireGameInfoNodeUpdate(target);
	}

    /**
     * \EҏWQ[̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
     */
	final protected void fireGameInfoNodeUpdate(NodeView target) {
		throwIfNotSetup();
	    for (GameInfoNodeMonitor monitor : 
	    	  parameter_.eventBroker_.getListeners(GameInfoNodeMonitor.class)) 
	    {
	    	monitor.gameInfoChanged(target);
	    }
	}

	/**
     * \Ăm[hƂȌ̃m[h̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
	 */
	final protected void fireNodeListUpdate() {
		throwIfNotSetup();
		GameMediator gameMediator = parameter_.collectionEditor_.getActiveGame();
		NodeList nodeList = gameMediator.getNodeList();
		int start = gameMediator.getCurrentNodeIndex();
		int end = nodeList.size();
		int index = 0;
		NodeView[] nodeViews = new NodeView[end - start];
		for (int i = start; i < end; ++i) {
			nodeViews[index] = nodeList.getNodeView(i);
			++index;
		}
		
		for (NodeListMonitor nodeListViewer 
				: parameter_.eventBroker_.getListeners(NodeListMonitor.class)) 
		{
			nodeListViewer.update(nodeViews);
		}
	}

	/**
     * \EҏWm[h̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
	 */
	final protected void fireNodeViewerUpdate() {
		fireNodeViewerUpdate(0);
	}
	
	/**
     * \EҏWm[h̕ύXʒm܂B<br>
     * {@link #setCollectionEditor(CollectionEditor)}A
     * {@link #setEventBroker(EventBroker)}ŐݒĂȂꍇ
     * {@link IllegalStateException}o܂B
     * 
     * @throws IllegalStateException {@link #collectionEditor_}A{@link #eventBroker_}null̏ꍇ
	 */
	final protected void fireNodeViewerUpdate(int delta) {
		throwIfNotSetup();
		StopWatch stopWatch = new StopWatch();
		GameMediator gameMediator = parameter_.collectionEditor_.getActiveGame();
		int index = gameMediator.getCurrentNodeIndex() + delta;
		if (index < 0 || gameMediator.getNodeList().size() <= index ) {
			index = gameMediator.getCurrentNodeIndex();
			log_s_.warn("Bad index, index=" + index + ", delta=" + delta);  //$NON-NLS-1$//$NON-NLS-2$
		}
		NodeView nodeView = gameMediator.getNodeList().getNodeView(index);
		for (NodeMonitor nodeViewer : parameter_.eventBroker_.getListeners(NodeMonitor.class)) {
			nodeViewer.currentChanged(nodeView);
    		if (log_s_.isTraceEnabled()) {
    			log_s_.trace(stopWatch.lapSecond() + " secs for " + nodeViewer);  //$NON-NLS-1$
    		}
		}
		if (log_s_.isTraceEnabled()) {
			log_s_.trace(stopWatch.stopSecond() + " secs for fireNodeViewerUpdate");  //$NON-NLS-1$
		}
	}

	/**
     * @param phase
     */
    final protected void fireHandlerPhaseChange(HandlerPhase phase) {
    	ArgumentChecker.throwIfNull(phase);
        if (phase.equals(HandlerPhase.SOLVE)) {
        	parameter_.collectionEditor_.getActiveGame().startSolvingProblem();
            fireNodeViewerUpdate();
        }

        for (ControllerStatusMonitor viewer 
        		: parameter_.eventBroker_.getListeners(ControllerStatusMonitor.class)) 
        {
        	viewer.changeHandlerPhase(phase);
        }
    }

    /**
     * lĂ鎞̏ԕύXʒm܂B
     */
    final protected void fireProblemStatusUpdate(ProblemStatus problemStatus) {
    	ArgumentChecker.throwIfNull(problemStatus);
        for (ProblemStatusMonitor viewer 
        		: parameter_.eventBroker_.getListeners(ProblemStatusMonitor.class)) 
        {
        	viewer.update(problemStatus);
        }
    }
    
	/**
	 * fɑ΂{@link org.unitarou.cmd.CommandDriver}oR̃R}h
	 * sꂽƂʒm܂B
	 * @param status
	 */
	protected void fireCommandDriverExecuted(Status status) {
    	ArgumentChecker.throwIfNull(status);
        for (CommandDriverMonitor listener 
        		: parameter_.eventBroker_.getListeners(CommandDriverMonitor.class)) 
        {
        	listener.commandExecuted(status);
        }
	}


    /**
	 * {@link #collectionEditor_}{@link #eventBroker_}A
	 * {@link #isEditMode_}̂ǂꂩł<code>null</code>̏ꍇɁA
	 * {@link IllegalStateException}𑗏o`FbN\bhłB 
	 */
	final protected void throwIfNotSetup() {
		if ((parameter_.collectionEditor_ == null) || (parameter_.eventBroker_ == null)
				|| (parameter_.isEditMode_ == null)){
			throw new IllegalStateException(
					"Bad state, CollectionEditor and EventBroker must be set before method invocation" //$NON-NLS-1$
					+ "collectionEditor_=" + parameter_.collectionEditor_  //$NON-NLS-1$
					+ ", eventBroker_=" + parameter_.eventBroker_ //$NON-NLS-1$
					+ ", isEditMode_=" + parameter_.isEditMode_); //$NON-NLS-1$
		}
	}

	/**
	 */
	private class ParameterImpl implements Parameter {

		private CollectionEditor collectionEditor_;
		
		
		private EventBroker eventBroker_;

		/**
		 * ݂ҏW[hǂێ܂B
		 */
		private Boolean isEditMode_;
		
		private HandlerPhase currentStatus_;

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#getCollectionEditor()
		 */
		public CollectionEditor getCollectionEditor() {
			return collectionEditor_;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#getEventBroker()
		 */
		public EventBroker getEventBroker() {
			return eventBroker_;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#isEditMode()
		 */
		public Boolean isEditMode() {
			return isEditMode_;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#getCurrentStatus()
		 */
		public HandlerPhase getCurrentStatus() {
			return currentStatus_;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#set(org.unitarou.yukinoshita.model.CollectionEditor, org.unitarou.yukinoshita.events.EventBroker, boolean)
		 */
		public void set(CollectionEditor collectionEditor, EventBroker eventBroker, boolean isEditMode) {
			ArgumentChecker.throwIfNull(collectionEditor, eventBroker);
			collectionEditor_ = collectionEditor;
			eventBroker_ = eventBroker;
			isEditMode_ = new Boolean(isEditMode);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#setCollectionEditor(org.unitarou.yukinoshita.model.CollectionEditor)
		 */
		public void setCollectionEditor(CollectionEditor collectionEditor) {
			ArgumentChecker.throwIfNull(collectionEditor);
			collectionEditor_ = collectionEditor;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		public void setEventBroker(EventBroker eventBroker) {
			ArgumentChecker.throwIfNull(eventBroker);
			eventBroker_ = eventBroker;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			isEditMode_ = new Boolean(isEditMode);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.cmd.Command4View.Parameter#setCurrentStatus(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void setCurrentStatus(HandlerPhase handlerPhase) {
			ArgumentChecker.throwIfNull(handlerPhase);
			currentStatus_ = handlerPhase;
		}
	}
}
