/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/**
 * Collection̕ҏW^ҏW[hύXꂽƂʒmR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ChangeEditModeCommand extends AbstractCommand4View {
	static private Log log_s_  = LogFactory.getLog(ChangeEditModeCommand.class);

	/**
	 * @param isEditMode ҏW[hɕςꍇtrue 
	 */
	public ChangeEditModeCommand(boolean isEditMode) {
		super();
		getParameter().setEditMode(isEditMode);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();
		StopWatch stopWatch = new StopWatch();
		CollectionEditor collectionEditor = getCollectionEditor();
		EventBroker eventBroker = getEventBroker();
		boolean isEditMode = isEditMode().booleanValue();
		
    	if (GameType.DRILL.equals(collectionEditor.getCollection().get(0).getGameType())) {
    		editModeChangedInDrill();
    		
    	} else {
            GameMediator gameMediator = collectionEditor.getActiveGame();
            eventBroker.connect(gameMediator.getGameType(), isEditMode);
            
            if (gameMediator.getGameType().equals(GameType.PROBLEM)) {
                if (isEditMode) {
                    gameMediator.finishSolvingProblem();
                    fireNodeViewerUpdate();
                } else {
                    gameMediator.startSolvingProblem();
                    fireHandlerPhaseChange(HandlerPhase.SOLVE);
                }
            }
    	}
     	
		if (log_s_.isTraceEnabled()) {
			log_s_.trace(stopWatch.stopSecond() + " secs for update");  //$NON-NLS-1$
		}
		
    	for (ControllerStatusMonitor viewer : 
    			eventBroker.getListeners(ControllerStatusMonitor.class)) 
    	{
        	viewer.setEditMode(isEditMode);
    	}
		if (log_s_.isTraceEnabled()) {
			log_s_.trace(stopWatch.stopSecond() + " secs for ControllerStatusMonitor.setEditMode");  //$NON-NLS-1$
		}
	}

	/**
     * {@link #editModeChanged(boolean)}{@link Collection}̐擪
     * W̏ꍇ̑s\bhłB<br>
     * 
     * ҏWJn(isEditMode: true)ɎIɌ݂̋l[obNāA
     * WȊO{@link RootGameTree}SăNA[܂B
     * 
     * ҏWI(isEditMode: false)͖W{@link RootGameTree}
     * Collectionɖǉ܂B
     */
    private void editModeChangedInDrill() {
		CollectionEditor collectionEditor = getCollectionEditor();
		EventBroker eventBroker_ = getEventBroker();
		boolean isEditMode = isEditMode().booleanValue();
		if (isEditMode) {// ҏWҏW[h
            collectionEditor.getActiveGame().finishSolvingProblem();
			collectionEditor.setActiveGame(0);
			
			// 擪ȊORootGameTree폜B
			while (1 < collectionEditor.size()) {
				collectionEditor.remove(1);
			}
			
            eventBroker_.connect(collectionEditor.getActiveGame().getGameType(), isEditMode);
			fireGameViewerUpdate();
			fireNodeViewerUpdate();
		} else {
			// 
			Collection collection = collectionEditor.getCollection();
			ViewerUtils.setupDriiRootDirectory(collection);
			CollectionRepository.instance().loadProblem(collection);
			collectionEditor.setActiveGame(1);
            eventBroker_.connect(collectionEditor.getActiveGame().getGameType(), isEditMode);
			fireGameViewerUpdate();
            collectionEditor.getActiveGame().startSolvingProblem();
            fireHandlerPhaseChange(HandlerPhase.SOLVE);
		}
    }
}
