/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.HandlerPhase;

/**
 * ViewTCh̃R}hłB̃C^[tFCXłUNDO͂ł܂B
 *  
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface Command4View {
	
	/**
	 * R}hɓnp[^̃C^[tFCXłB 
	 */
	interface Parameter {
		/**
		 * ݕێĂ{@link CollectionEditor}Ԃ܂B<br>
		 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
		 * @return
		 */
		CollectionEditor getCollectionEditor();
		
		
		/**
		 * ݕێĂ{@link EventBroker}Ԃ܂B<br>
		 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
		 * @return
		 */
		EventBroker getEventBroker();
		
		/**
		 * ݂̕ҏWEҏW[h̒lԂ܂B
		 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
		 * @return
		 */
		Boolean isEditMode();
		
		/**
		 * ݂̑샂[h̒lԂ܂B
		 * ݒ̏ꍇ<code>null</code>ԂƂ܂B
		 * @return
		 */
		HandlerPhase getCurrentStatus();

		/**
		 * R}hsɕKvȎsΏۂƏw肵܂B
		 * 
		 * @param collectionEditor
		 * @param eventBroker
		 * @param isEditMode
		 * 
		 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
		 */
		void set(CollectionEditor collectionEditor, EventBroker eventBroker, boolean isEditMode);

		/**
		 * R}hsɗp{@link CollectionEditor}w肵܂B
		 * @param collectionEditor
		 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
		 */
		void setCollectionEditor(CollectionEditor collectionEditor);
		
		/**
		 * R}hsɗp{@link EventBroker}w肵܂B
		 * @param eventBroker
		 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
		 */
		void setEventBroker(EventBroker eventBroker);

		/**
		 * ViewݕҏW[hۂw肵܂B
		 * @param isEditMode
		 */
		void setEditMode(boolean isEditMode);
		
		
		/**
		 * ݂̑샂[hݒ肵܂B
		 * @param handlerPhase
		 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
		 */
		void setCurrentStatus(HandlerPhase handlerPhase);
	}
	
	
	/**
	 * R}hs܂B
	 * s܂ł{@link #setCollectionEditor(CollectionEditor)}
	 * {@link #setEventBroker(EventBroker)}ݒ̏ꍇ
	 * {@link IllegalStateException}𑗏o܂B
	 * @throws IllegalStateException set...nݒŎss\̏ꍇB
	 */
	void execute();
	

	/**
	 * R}hɐݒ肳Ăp[^Ԃ܂B<br>
	 * <code>null</code>͕Ԃ܂B
	 * @return
	 */
	Parameter getParameter();
	
}