/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;

/**
 * W̕ҏWɎw肵{@link org.unitarou.sgf.Collection}(ŴPt@C)܂
 * {@link org.unitarou.sgf.RootGameTree}(̒̂P)ɃtH[JXڂR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FocusInDrillEditorCommand extends AbstractCommand4View {
	
	private final Collection collection_;
	private final RootGameTree rootGameTree_;

	/**
	 * ŴPt@CɃtH[JXʂꍇ̃RXgN^łB
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	public FocusInDrillEditorCommand(Collection collection) {
		super();
		ArgumentChecker.throwIfNull(collection);
		collection_ = collection;
		rootGameTree_ = null;
	}

	/**
	 * ŴPt@ĈPɃtH[JXʂꍇ̃RXgN^łB
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	public FocusInDrillEditorCommand(RootGameTree rootGameTree) {
		super();
		ArgumentChecker.throwIfNull(rootGameTree);
		collection_ = null;
		rootGameTree_ = rootGameTree;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();
		for(OutlineMonitor outlineViwer : 
			getParameter().getEventBroker().getListeners(OutlineMonitor.class)) 
		{
			if (collection_ != null) {
				outlineViwer.setFocus(collection_);
			} else if (rootGameTree_ != null) {
				outlineViwer.setFocus(rootGameTree_);
			} else {
				assert false : "Unknows status."; //$NON-NLS-1$
			}
		}
	}
}
