/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/**
 * ̉𓚃[hŃ[U\ȓ_IꍇɎsR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class MoveInProblemCommand extends AbstractCommand4View {
	
	private final SgfPoint point_;

	/**
     * @param point [UI_
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public MoveInProblemCommand(SgfPoint point) {
		super();
		ArgumentChecker.throwIfNull(point);
		point_ = point;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();

        // 1.̒({Aω}[ǂpX])ɊYꍇ͂̃m[hɐi
        //   LȊO̓_ɒ肵ꍇ́AŏɌpX̃m[hɐiށB
        // 2.pX̃m[hꍇ́uԈႢvŏI
        GameMediator gameMediator = getCollectionEditor().getActiveGame();
        if (selectPlayerMove(gameMediator, point_)) {
            // ԈႢ\ďI
    		fireNodeViewerUpdate();
            fireProblemStatusUpdate(ProblemStatus.WRONG);
            return;
        }
        SgfColor player = gameMediator.getCurrentNodeView().getMove().getColor();
        // 3.i񂾃m[h̒([Uw肵)\āAw~b҂
        try {
    		fireNodeViewerUpdate();
            Thread.sleep(200);
        } catch (InterruptedException ignore) {
            // 荞݂͖
        }
        

        // 4.̃m[h(܂A)IBω}ꍇ̓_Ɍ߂B
        //    Ԃ̊ԈႢɂẮAUۗ
        if (selectOppositeMove(gameMediator)) {
            fireNodeViewerUpdate();
        }
        
        // ܂c܂l邪ꍇ͈ȍ~͍̔sȂB
        if (!gameMediator.getCurrentNodeView().isLast()) {
            return;
        }
        

        // 5. ̃m[hꍇ͏IB{́uvAω}͌uԈႢv
        //    ŏIm[hɍԂȂGB,ԂȂGWƁuv
        if (isInMainPath(gameMediator)) { // 
            fireProblemStatusUpdate(ProblemStatus.CORRECT);
            return;
        }

        NodeView nodeView = gameMediator.getCurrentNodeView();
        fireProblemStatusUpdate(judge(nodeView, player));
	}

	/**
	 * lĂԂŁApointɒ肵ꍇŎ̑̒ɑJڂ܂B
	 * őJڂ̃[́F
	 * <ol>
	 * <li>̒({Aω}[ǂpX])ɊYꍇ͂̃m[hɐiށB</li>
	 * <li>LȊO̓_ɒ肵ꍇ́AŏɌpX̃m[hɐiށB
	 *     ̍ۂɃpXpoint̒ɒuB</li>
	 * <li>ȊȌꍇ͒肪ԈႢŁA̕ω}쐬ĐiށB</li>
	 * </ol> 
	 * ԈႢ̏ꍇA܂SOLVE[hIƂtrueԂ܂B
	 * 
     * @param gameMediator
     * @param point
     * @return 肪͂ԈႢƕꍇtrueB܂Ȃꍇfalse
     */
    private boolean selectPlayerMove(GameMediator gameMediator, SgfPoint point) {
        NodeView nodeView = gameMediator.getCurrentNodeView();

        NodeView nextNode;
        if (nodeView.isChildrenStyle()) {
            // eq^̏ꍇAω}𒲂ׂĂ玟̔Ԃɐi߂
            boolean selected = selectPlayerMoveByVariation(gameMediator, point);
            nextNode = gameMediator.setNodeIndexDelta(+1);
            if (selected){
                return false;
            } 
            if (point.equals(nextNode.getMove().getPoint())) {
                // {
                return false;
            }
            // Y钅薳As
            gameMediator.setNodeIndexDelta(-1);
            gameMediator.executeCommand(new AddVariation(nextNode.getMove().getColor(), point));
            gameMediator.setNodeIndexDelta(+1);
            return true;
        }

        //Z^̏ꍇA̔Ԃɐi߂Ăω}𒲂ׂ
        nextNode = gameMediator.setNodeIndexDelta(+1);
        if (selectPlayerMoveByVariation(gameMediator, point)) {
            return false;
        }
        if (point.equals(nextNode.getMove().getPoint())) {
            // {
            return false;
        }
        // Y钅薳As
        gameMediator.setNodeIndexDelta(-1);
        gameMediator.executeCommand(new AddVariation(nextNode.getMove().getColor(), point));
        return false;
    }

    /**
     * gameMediatořݒڂĂ{@link NodeView}̕ω}ApointɃ}b`
     * ̂ꍇɂ͂̕ω}I܂B
     * ȂAω}PASSApointɃ}b`Iꍇ́A
     * PASS̕ω}IAPASS̎pointɒu܂B
     * 
     * ω}IłꍇtrueԂ܂B
     * Iłω}ꍇ(ω}̂̂ꍇ܂)falseԂ܂B
     * @param gameMediator
     * @param point
     */
    private boolean selectPlayerMoveByVariation(GameMediator gameMediator, SgfPoint point) {
        NodeView nodeView = gameMediator.getCurrentNodeView();
        NodeView[] variations = nodeView.getVariations();
        if (variations.length == 0) {
            return false;
        }

        int passNodeIndex = -1;
        Stone passMove = null;
        for (int i = 0; i < variations.length; i++) {
        	passMove = variations[i].getMove();
            SgfPoint varPoint = passMove.getPoint();
            if ( (passNodeIndex == -1) && (varPoint != null)
                    && (varPoint.condition().equals(SgfPointType.PASS))) {
                passNodeIndex =  i;
        
            } else if (point.equals(varPoint)){
            	gameMediator.executeCommand(new SelectVariation(i));
                return true;
            }
        }
        
        if (passNodeIndex != -1) {
        	gameMediator.executeCommand(new SelectVariation(passNodeIndex));
        	SgfId sgfId = passMove.getColor().moveType();
        	gameMediator.executeCommand(
        				new UpdateProperty(
        						new Property[0],
        						new Property(sgfId, point.getString()), 
        						null));
            return true;
        }
        return false;
    }

    /**
	 * lő葤̒肵܂B
	 * 肪IłꍇtrueԂ܂B
     * @param gameMediator
     */
    private boolean selectOppositeMove(GameMediator gameMediator) {
        NodeView playerView = gameMediator.getCurrentNodeView();
        if (playerView.isLast()) {
            return false;
        }
        
        // eq^̏ꍇA̕ω}͑ԂɂȂ
        if (playerView.isChildrenStyle()) {
            NodeView[] variations = playerView.getVariations();
            if (variations.length != 0) {
            	int variationIndex = getOppositeVariationIndex(variations);
            	if (0 < variationIndex) {
            		gameMediator.executeCommand(new SelectVariation(variationIndex));	
            	}
            }
            gameMediator.setNodeIndexDelta(+1);
            return true;
        }
        
        // Z^̏ꍇAω}mׂɂ͈i߂KvB
        gameMediator.setNodeIndexDelta(+1);
        NodeView[] variations = gameMediator.getCurrentNodeView().getVariations();
        if (variations.length != 0) {
        	int variationIndex = getOppositeVariationIndex(variations);
        	if (0 < variationIndex) {
        		gameMediator.executeCommand(new SelectVariation(variationIndex));	
        	}
        }
        return true;
    }
    
    /**
     * @return ɍ肪ꍇ-1ԂB
     */
    private int getOppositeVariationIndex(NodeView[] nodeViews) {
    	List<Integer> indices = new ArrayList<Integer>(nodeViews.length);
    	for (int i = 0 ; i < nodeViews.length; ++i) {
    		Property property = nodeViews[i].getProperty(SgfId.BAD_MOVE);
    		if (property == null) {
    			indices.add(new Integer(i));
    		} else if (false) { //TODO ǂ͕ʓrReLXgŎw肳B
    			
    		}
    	}
    	
    	if (indices.isEmpty()) {
    		return -1;
    	}
        Random random = new Random();
        return indices.get(random.nextInt(indices.size())).intValue();
    }

    /**
     * gameMediatořݒڂĂm[h{łƂtrueԂ܂B
     * {͂̃m[h㗬̕ω}ׂĂŏ̃c[IłԂƒ`܂B
     * @param gameMediator
     * @return
     */
    private boolean isInMainPath(GameMediator gameMediator) {
        int index = gameMediator.getCurrentNodeIndex();
        while (0 <= index) {
            NodeView n = gameMediator.getNodeList().getNodeView(index);
            if (0 < n.getSelectedVariationIndex()) {
                return false;
            }
            --index;
        }
        return true;
    }
    
    /**
     * nodeViewplayerɗLȕ](GB[2]܂GW[2])ꍇ{@link ProblemStatus#CORRECT}Ԃ܂B
     * ܂(GB[1]܂GW[1])ꍇ{@link ProblemStatus#QUASI_CORRECT}Ԃ܂B
     * player{@link SgfColor#BLACK}̏ꍇ{@link SgfId#GOOD_FOR_BLACK}
     * player{@link SgfColor#WHITE}̏ꍇ{@link SgfId#GOOD_FOR_WHITE}]܂B
     * 
     * @param nodeView
     * @param player
     * @return {@link ProblemStatus#CORRECT}A{@link ProblemStatus#QUASI_CORRECT}܂{@link ProblemStatus#WRONG}
     */
    private ProblemStatus judge(NodeView nodeView, SgfColor player) {
        Property property = null;
        if (SgfColor.BLACK.equals(player)) {
            property =  nodeView.getProperty(SgfId.GOOD_FOR_BLACK);
        } else if (SgfColor.WHITE.equals(player)) {
            property =  nodeView.getProperty(SgfId.GOOD_FOR_WHITE);
        }
        if (property != null) {
            SgfDouble value = SgfDouble.parseQuietly(property.getString());
            if (SgfDouble.EMPHASIZED.equals(value)) {
            	return ProblemStatus.CORRECT;
            }
            if (SgfDouble.NORMAL.equals(value)) {
            	return ProblemStatus.QUASI_CORRECT;
            }
        }
    	return ProblemStatus.WRONG;
    }
}
