/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.unitarou.sgf.PropertyType;
import org.unitarou.yukinoshita.model.GameMediator;

/**
 * m[hXgɂđΈʒudeltaړ܂B
 * deltȁꍇi߁Ȁꍇ߂܂B 
 *  
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class NodeJumpCommand extends AbstractCommand4View {

	/**
	 * Έړʂێ܂B
	 */
	private final int delta_;
	
	/**
	 * @param delta ݂{@link org.unitarou.yukinoshita.model.NodeView}̑Έړʂw肵܂B
	 */
	public NodeJumpCommand(int delta) {
		super();
		delta_ = delta;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();
		GameMediator gameMediator = getCollectionEditor().getActiveGame();
		int lastIndex = gameMediator.findNodeView(PropertyType.GAME_INFO);
		gameMediator.setNodeIndexDelta(delta_);
		fireNodeViewerUpdate();

		int newIndex = gameMediator.findNodeView(PropertyType.GAME_INFO);
		if (lastIndex != newIndex) {
			newIndex = (newIndex < 0) ? 0 : newIndex;
			fireGameInfoNodeUpdate(gameMediator.getNodeList().getNodeView(newIndex));
		}
	}
}
