/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.unitarou.sgf.PropertyType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;

/**
 * \{@link org.unitarou.yukinoshita.model.NodeView}ύXR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class NodeSelectionCommand extends AbstractCommand4View {

	/**
	 * INodeViewIndexێ܂B
	 */
	private final int nodeIndex_;
	
	/**
	 * @throws IllegalArgumentException nodeIndex̒l̏ꍇB 
	 */
	public NodeSelectionCommand(int nodeIndex) {
		super();
		ArgumentChecker.throwIfNegative(nodeIndex);
		nodeIndex_ = nodeIndex;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();

		GameMediator gameMediator = getCollectionEditor().getActiveGame();
		int lastIndex = gameMediator.findNodeView(PropertyType.GAME_INFO);
		gameMediator.setNodeIndex(nodeIndex_);
		fireNodeViewerUpdate();

		int newIndex = gameMediator.findNodeView(PropertyType.GAME_INFO);
		if (lastIndex != newIndex) {
			newIndex = (newIndex < 0) ? 0 : newIndex;
			fireGameInfoNodeUpdate(gameMediator.getNodeList().getNodeView(newIndex));
		}
	}
}
