/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;

/**
 * W̕\(ĕ\)wR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ShowDrillCommand extends AbstractCommand4View {
	static private final Log log_s_ = LogFactory.getLog(ShowDrillCommand.class);

	
	private final Collection[] collections_;

	/**
	 * 
	 */
	public ShowDrillCommand(Collection[] collections) {
		super();
		ArgumentChecker.throwIfNull((Object)collections);
		
		collections_ = new Collection[collections.length];
		System.arraycopy(collections, 0, collections_, 0, collections_.length);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();
		StopWatch stopWatch = new StopWatch();
		for(OutlineMonitor outlineViwer : 
				getParameter().getEventBroker().getListeners(OutlineMonitor.class)) 
		{
			outlineViwer.show(collections_);
			
    		if (log_s_.isTraceEnabled()) {
    			log_s_.trace(stopWatch.lapSecond() + " secs for " + outlineViwer);  //$NON-NLS-1$
    		}
		}
		if (log_s_.isTraceEnabled()) {
			log_s_.trace(stopWatch.stopSecond() + " secs for fireOutlineViwer#show");  //$NON-NLS-1$
		}
	}
}
