/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.cmd.CommandDriver.Status;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.StartSolvingProblem;

/**
 * {@link org.unitarou.yukinoshita.model.cmd.Command4NodeList}bvR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class WrapperCommand extends AbstractCommand4View {
	
	static private final Log log_s_ = LogFactory.getLog(WrapperCommand.class);
	
	/**
	 * {[hłs\ȃR}h̏WłB<br>
	 * WbN`FbNpɗpĂ܂B
	 */
	static private Set<Class<? extends Command4NodeList>> permittedCommandInView_s_;
	static  {
		permittedCommandInView_s_= new HashSet<Class<? extends Command4NodeList>>(2);
		permittedCommandInView_s_.add(SelectVariation.class);
		permittedCommandInView_s_.add(StartSolvingProblem.class);
	}
	/**
	 * bvR}hłB 
	 */
	private final Command4NodeList wrappedCommand_;
	
	
	/**
	 * 
	 */
	public WrapperCommand(Command4NodeList command) {
		super();
		ArgumentChecker.throwIfNull(command);
		wrappedCommand_ = command;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.cmd.Command4View#execute()
	 */
	public void execute() {
		throwIfNotSetup();
		if (!isEditMode().booleanValue() && !permittedCommandInView_s_.contains(wrappedCommand_.getClass())) {
			log_s_.warn("Execute command in non-edit mode (BUG ?)." + wrappedCommand_); //$NON-NLS-1$
		}
		GameMediator gameMediator = getCollectionEditor().getActiveGame();
		Status status = gameMediator.executeCommand(wrappedCommand_);
		fireCommandDriverExecuted(status);
		for (ModelInfluence influence : wrappedCommand_.getInfluence()) {
			switch (influence) {
			case COLLECTION:
				fireCollectionViewerUpdate();
				break;

			case ROOT_GAME_TREE:
				fireGameViewerUpdate();
				break;
				
			case NODE_GAMEINFO:
				fireGameInfoNodeUpdate();
				break;

			case NODE_DOWNWARD:
				fireNodeListUpdate();
				break;

			case NODE_PEVIOUS:
				fireNodeViewerUpdate(-1);
				break;

			case NODE_CURRENT:
				fireNodeViewerUpdate();
				break;

			default:
				log_s_.warn("Unsupported influence type, ignore it:" + influence); //$NON-NLS-1$
				break;
			}
		}
		SgfArgumentChecker.throwIfInvalid(getCollectionEditor().getActiveGame().getRootGameTree());
	}
}
