/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.ModelFrame;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.JFaceMenuManager;
import org.unitarou.yukinoshita.view.jface.dlg.AskSaveDialog;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.gm.GameSingleFrame;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * JFacex[X̃EBhENXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class JFaceWindow extends ApplicationWindow 
		implements Adaptable, WindowController
{
    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(JFaceWindow.class);
	
	static private final String MARK_EDITED = "*"; //$NON-NLS-1$
	
	static private ImageResource[] IMG_APPS = null;

	static private Image[] getAppIcons() {
		if (IMG_APPS == null) {
			IMG_APPS = new ImageResource[2];
			IMG_APPS[0] = new ImageResource(JFaceWindow.class, "iconApp16.png"); //$NON-NLS-1$ 
			IMG_APPS[1] = new ImageResource(JFaceWindow.class, "iconApp32.png"); //$NON-NLS-1$ 
		}
		return new Image[]{IMG_APPS[0].get(), IMG_APPS[1].get()};
	}
	
		
	/** t@C̕ۑɎs܂B */
	static private final MessageResource NT_FILE_SAVE_FAILURE
			= new MessageResource(JFaceWindow.class, "ntFileSaveFailure"); //$NON-NLS-1$
	
	/**
	 * uLmV^ version {0}v
	 */
	static public final MessageResource NT_YUKINOSHITS
			= new MessageResource(JFaceWindow.class, "ntYukinoshita"); //$NON-NLS-1$
	
	/**
	 * EBhẼTCYێReLXgŁAftHg(800,640)łB
	 */
	static private final IntArrayContextValue SIZE
			= new IntArrayContextValue(JFaceWindow.class, "size", new int[]{800, 640}); //$NON-NLS-1$
	

	/**
	 * m[h̕ύXĎāAҏWꂽǂ`FbN܂B
	 */
	private class Adapter implements GameMonitor, GameInfoNodeMonitor, NodeMonitor {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
            updateFileModifyMark();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.NodeMonitor#gameInfoUpdated(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void gameInfoUpdated(NodeView gameInfoNode) {
            updateFileModifyMark();
		}

		/* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
         */
        public void currentChanged(NodeView nodeView) {
            updateFileModifyMark();
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor#gameInfoChanged(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void gameInfoChanged(NodeView nodeView) {
            updateFileModifyMark();
		}
	}
	
	/**
	 * 
	 */
	private class Notifier extends TieredModelEventNotifier {

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
            return new Adaptable[]{menuManager_};
        }
	}
	

	private final JFaceMenuManager menuManager_;
	private CTabFolder tabFolder_;
	private final Adapter adapter_;
	private final ShellAdapter shellAdapter_;
	private final Notifier notifier_;
	private final List<WindowControllerListener> listeners_;
	


    /**
     * @param parentShell
     */
    public JFaceWindow(Shell parentShell) {
        super(parentShell);
        listeners_ = new ArrayList<WindowControllerListener>();
        menuManager_ = new JFaceMenuManager(this);
        tabFolder_ = null;
        super.addMenuBar();
        adapter_ = new Adapter();
        shellAdapter_ = new ShellAdapter() {
            @Override
			public void shellClosed(ShellEvent event) {
            	closeThis(event);
            }
        };
        notifier_ = new Notifier();
    }
    
    /**
     * @param event
     */
    private void closeThis(ShellEvent event) {
    	event.doit = closeAllTabs();
    	if (event.doit) {
    		super.close();
    	}
    }
    

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /**
     * Window̕\łȂ
     * ݒłȂԂݒ肵܂B
     * @see org.eclipse.jface.window.Window#create()
     */
    @Override
	public void create() {
        super.create();
        menuManager_.initialize();
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull(parent);

        getShell().setImages(getAppIcons());
        getShell().setText(JFaceWindow.NT_YUKINOSHITS.get(Yukinoshita.instance().getVersion()));
        tabFolder_ = new CTabFolder(parent, SWT.TOP | SWT.CLOSE | SWT.BORDER);
        tabFolder_.setSimple(false);   
        tabFolder_.addCTabFolder2Listener(new CTabFolder2Adapter() {
            @Override
			public void close(CTabFolderEvent event) {
                GameFrameController gfc = (GameFrameController)event.item.getData();
                event.doit = closeTab(gfc);
                if (event.doit) {
                    event.item.setData(null);
                    event.item.dispose();
                    changeCurrentTabItem();
                }
            }
        });
        tabFolder_.addSelectionListener(new SelectionAdapter() {
            @Override
			public void widgetSelected(SelectionEvent e) {
                changeCurrentTabItem();
            }
        });
        Display display = tabFolder_.getDisplay();
        tabFolder_.setSelectionBackground(
                new Color[] {
                        	display.getSystemColor(SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW),
                        	display.getSystemColor(SWT.COLOR_WIDGET_BACKGROUND)},
                new int[]{100},
                true);
		CurrentContext context = Yukinoshita.context().getCurrent(null);
		int[] size = context.getIntArray(SIZE);
		getShell().setSize(size[0], size[1]);
        return tabFolder_;
    }
    
    /**
     * őOʂɕ\^u؂ւƂɌĂяo܂B
     * 
     * ҏW̗LmFA
     * ɍ킹āuۑ(S)v{^Enable/Disable
     * ^u̍̃AX^XN̗LXV܂B
     */
    private void changeCurrentTabItem() {
    	GameFrameController gfc = getActive();
    	for (WindowControllerListener listener : listeners_) {
    		listener.changeActive(gfc);
    	}
    	
    	//MEMO yk_226΍B
    	if (gfc != null) {
        	NodeView nodeView = gfc.getCollectionEditor().getActiveGame().getCurrentNodeView();
        	for (NodeMonitor nodeMonitor : gfc.getEventBroker().getListeners(NodeMonitor.class)) {
        		nodeMonitor.currentChanged(nodeView);
        	}
    	}
    	
        updateFileModifyMark();
    }
    
    /**
     * ݂̃t@CύXĂ邩`FbN
     * ύXĂꍇ̓^ũt@C̐擪{@link #MARK_EDITED}܂B
     */
    private void updateFileModifyMark() {
        CTabItem item = tabFolder_.getSelection();
        if (item == null) {
            log_s_.warn("Selected tabitem is not found."); //$NON-NLS-1$
            return;
        }
        GameFrameController gfc = getActive();
        File file = gfc.getCollection().getFile();
        String name = file != null ? file.getName() : item.getText();
        if (name.startsWith(MARK_EDITED)) {
        	name = name.substring(MARK_EDITED.length());
        }
        item.setText(gfc.isChanged() ? MARK_EDITED + name : name); 
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.window.Window#getShellListener()
     */
    @Override
	protected ShellListener getShellListener() {
        return shellAdapter_;
    }
    
	/**
	 * \t[𐶐āA^uɒǉ܂B
	 * ǉ^uIꂽԂɂȂ܂B
	 */
	private ModelFrame createGameFrame(String tabName) {
		GameSingleFrame modelFrame = new GameSingleFrame();
		Control control = modelFrame.createContents(tabFolder_);
		CTabItem item = new CTabItem(tabFolder_, SWT.NONE);

		item.setText(tabName);
		item.setControl(control);
		tabFolder_.setSelection(item);
		return modelFrame;
	}
    
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.window.ApplicationWindow#createMenuManager()
     */
	@Override
    protected MenuManager createMenuManager() {
        MenuManager menuManager = super.createMenuManager();
        menuManager_.createMenu(menuManager);
        return menuManager;
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.ApplicationWindow#close()
	 */
	@Override
	public boolean close() {
		if (closeAllTabs()) {
			return super.close();
		}
		return false;
	}

	/**
     * ShellƂɁAS^uɑ΂Close(ۑmF)sB
     * @return SẴ^uClosełꍇtrueBPłLZꂽꍇfalseB
     */
    private boolean closeAllTabs() {
        CTabItem[] items = tabFolder_.getItems();
        for (int i = 0; i < items.length; ++i) {
            GameFrameController gfc = (GameFrameController)items[i].getData();
            boolean doit = closeTab(gfc);
            if (!doit) {
                return false;
            }
            items[i].setData(null);
            items[i].dispose();
        }
        return true;
    }

    /**
     * ^uƂɊ̕ύXmF
     * KvłΕۑ悤Ƀ[Uɑ܂B
     * @return trueŃN[Y
     */
    private boolean closeTab(GameFrameController gfc) {
    	if (gfc == null) {
    		return true;
    	}
        if (!gfc.isChanged()) {
            FileManager.instance().close(gfc.getCollection());
			gfc.getEventBroker().removeView(this);
            gfc.dispose();
            return true;
        }

        AskSaveDialog dialog = new AskSaveDialog(getShell(), gfc);
        int id = dialog.open();
        switch (id) {
        case AskSaveDialog.SAVEAS_ID:
        	File file = IgoFileDialog.askSaveFile(gfc.getCollection());
        	if (file == null) {// LZ̏ꍇ
        	    return false;
        	}
        	
        	FileManager.instance().close(gfc.getCollection());
        	gfc.getCollection().setFile(file);
        	// ̃P[X(SAVE_ID)ɑ

        case AskSaveDialog.SAVE_ID:
    		try {
    		    FileManager.instance().save(gfc.getCollection());
            } catch (YukinoshitaException e) {
                log_s_.error(NT_FILE_SAVE_FAILURE.get(), e);
                MessageDialog.openError(
                        getShell(),
                        NT_FILE_SAVE_FAILURE.get(), 
                        e.getLocalizedMessage());
        	    return false;
            }
        	// ̃P[X(NOSAVE_ID)ɑ

        case AskSaveDialog.NOSAVE_ID:
        	FileManager.instance().close(gfc.getCollection());
        	gfc.getEventBroker().removeView(this);
        	gfc.dispose();
            return true;

        case AskSaveDialog.CANCEL_ID:
       	    return false;
       	
       	default:
       	    assert true : "Unknown type: " + id; //$NON-NLS-1$
       		return false;
        }
    }


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.WindowController#register(org.unitarou.sgf.Collection, java.lang.String)
	 */
	public void register(Collection collection, String tabName, boolean setChangedFlag) {
		ArgumentChecker.throwIfNull(collection);
		if (collection.getFile() == null && tabName == null) {
			throw new IllegalArgumentException("No tabName"); //$NON-NLS-1$
		}
		if (collection.getFile() != null) {
			tabName = collection.getFile().getName();
		}
        ModelFrame mf = createGameFrame(tabName);
		GameFrameController gfc = new GameFrameController(collection, mf, setChangedFlag);
		gfc.getEventBroker().addView(this);
		notifier_.setEventBroker(gfc.getEventBroker());
		// TabItemGameFrameControllerRtB
		// TabItemDisposerŗpB
		// MEMO createCollectionFrame()͂̊pCTabItemIĂ邪AȂgbL[
		tabFolder_.getSelection().setData(gfc);
        changeCurrentTabItem();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.WindowController#getActive()
	 */
	public GameFrameController getActive() {
		CTabItem tabItem = tabFolder_.getSelection();
		return (tabItem != null) ? (GameFrameController)tabItem.getData() : null;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#getGameFrameControllers()
	 */
	public GameFrameController[] getGameFrameControllers() {
		CTabItem[] items = tabFolder_.getItems();
		GameFrameController[] ret = new GameFrameController[items.length];
		for (int i = 0; i < ret.length; ++i) {
			ret[i] = (GameFrameController)items[i].getData();
		}
		return ret;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#closeActive()
	 */
	public boolean closeActive() {
		CTabItem tabItem = tabFolder_.getSelection();
		if (tabItem == null) {
			return false;
		}
        GameFrameController gfc = (GameFrameController)tabItem.getData();
        if (closeTab(gfc)) {
        	tabItem.setData(null);
        	tabItem.dispose();
        	return true;
        }
        return false;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#addListener(org.unitarou.yukinoshita.events.WindowControllerListener)
	 */
	public void addListener(WindowControllerListener listener) {
		if (listener != null) {
			listeners_.add(listener);
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#removListener(org.unitarou.yukinoshita.events.WindowControllerListener)
	 */
	public void removListener(WindowControllerListener listener) {
		listeners_.remove(listener);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#defaultLayout()
	 */
	public void defaultLayout() {
		int[] size = SIZE.defaultIntArray();
		getShell().setSize(size[0], size[1]);
		GameFrameController gfc = getActive();
		if (gfc == null) {
			return;
		}
        for (LayoutMonitor viewer : gfc.getEventBroker().getListeners(LayoutMonitor.class)) {
        	viewer.defaultLayout();
        }
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#loadLayout()
	 */
	public void loadLayout() {
		CurrentContext context = Yukinoshita.context().getCurrent(null);
		int[] size = context.getIntArray(SIZE);
		getShell().setSize(size[0], size[1]);
		GameFrameController gfc = getActive();
		if (gfc == null) {
			return;
		}
        for (LayoutMonitor viewer : gfc.getEventBroker().getListeners(LayoutMonitor.class)) {
        	viewer.loadLayout();
        }
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.WindowController#saveLayout()
	 */
	public void saveLayout() {
		CurrentContext context = Yukinoshita.context().getCurrent(null);
		Point point = getShell().getSize();
		context.setIntArray(SIZE.id(), new int[]{point.x, point.y});
		GameFrameController gfc = getActive();
		if (gfc == null) {
			Yukinoshita.context().saveContext();
			return;
		}
        for (LayoutMonitor viewer : gfc.getEventBroker().getListeners(LayoutMonitor.class)) {
        	viewer.saveLayout();
        }
		Yukinoshita.context().saveContext();
	}
}
