/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.action.Action;

import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.WindowController;

/**
 * {@link #controller_}ێA
 * {@link #actionName_}RXgN^ɍ쐬AuXgNgNXłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
abstract public class AbstractAction extends Action {

	protected final WindowController controller_;
	
	/**
	 * "NX.clbName" Ŏw肳郁bZ[W\[XłB
	 */
	protected final MessageResource actionName_;
	
	/**
	 * {@link #actionName_}Ɏ̃NX̃pbP[Wɂ
	 * messages.propertieśũNXFQCNv{u.clbNamevŎw肳ꂽ
	 * O{@link Action#setText(java.lang.String)}Ɏw肵܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	public AbstractAction(WindowController controller) {
		super();
		ArgumentChecker.throwIfNull(controller);
		controller_ = controller;
		actionName_ = new MessageResource(this.getClass(), "clbName"); //$NON-NLS-1$
		setText(actionName_.get());
	}
}
