/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EnumSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/**
 * {@link org.unitarou.sgf.RootGameTree}̂̂̒ǉύXANV́A
 * ʉNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class AbstractRootGameTreeAction extends AbstractAction implements Adaptable {

	/**
	 * ̃NX̃K[łB
	 */
	static private final Log log_s_ = LogFactory.getLog(AbstractRootGameTreeAction.class);

	/**
	 * ȑO{@link #changeActive(GameFrameController)}
	 * w肳ꂽCX^XQƂŕێ܂B
	 */
	private Reference<GameFrameController> refGfc_;
	/**
	 *  
	 */
	private final Adapter adapter_;

	/**
	 * @param controller
	 */
	public AbstractRootGameTreeAction(WindowController controller) {
		super(controller);
		refGfc_ = new WeakReference<GameFrameController>(null);
		adapter_ = new Adapter();
		controller.addListener(adapter_);
	}

	public Object getAdapter(Class<?> adapter) {
	    if (adapter == null) {
	        return null;
	    }
	    if (adapter.isAssignableFrom(adapter_.getClass())) {
	        return adapter_;
	    }
	    return null;
	}

	/**
	 * ݃tH[JXĂ{@link GameFrameController}Ԃ܂B<br>
	 * ^u1ꍇȂǁA<code>null</code>ԂƂ肦܂B
	 * @return
	 */
	protected final GameFrameController getGameFrameController() {
		return refGfc_.get();
	}
	
	/**
	 * {@link org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog}
	 * ݒtOԂ܂B<br>
	 * ̃NXł̎́F
	 * 1. {@link org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type#PERMITS_NEW_FILE}
	 * 2. ݑIĂ{@link org.unitarou.yukinoshita.model.GameMediator}
	 *    Gamȅꍇ@link org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type#PERMITS_GAME}
	 * 3. ݑIĂ{@link org.unitarou.yukinoshita.model.GameMediator}
	 *    Problem̏ꍇ@link org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type#PERMITS_PROBLEM}
	 * łB
	 * @return
	 */
	protected EnumSet<Type> getTypes() {
		EnumSet<Type> typeSet = EnumSet.of(Type.PERMITS_NEW_FILE);
		GameFrameController gfc = getGameFrameController();
		if (gfc == null) {
			return typeSet;
		}
		GameType gameType = gfc.getCollectionEditor().getActiveGame().getGameType(); 
		switch (gameType) {
		case GAME:
			typeSet.add(Type.PERMITS_GAME);
			return typeSet;
			
		case PROBLEM:
			typeSet.add(Type.PERMITS_PROBLEM);
			return typeSet;

		default:
			log_s_.warn("Unsupported game type (Maybe BUG). TYPE:" + gameType.name()); //$NON-NLS-1$
			return EnumSet.noneOf(Type.class);
		}
	}

	/**
	 * ANVs\ȂƂ<code>true</code>Ԃ܂B<br>
	 * ̓Iɂ͈ȉ̏SĖĂ鎞ɃANV͎s\łF<br>
	 * 1. now<code>null</code><br>
	 * 2. nowҏW[hłB
	 * 3. nowɂQȏ{@link org.unitarou.sgf.RootGameTree}݂B<br>
	 * 4. nowW(擪RootGameTreeDRILL)ȊOB<br>
	 * 
	 * @param now
	 * @return
	 */
	protected boolean isRunnable(GameFrameController now) {
		if (now == null || !now.isEditMode()) {
			return false;
		}
		Collection collection = now.getCollection();
		if (collection.size() < 2) {
			return false;
		}
		
		return !GameType.DRILL.equals(collection.get(0).getGameType());
	}

	/**
	 * gfc{@link org.unitarou.yukinoshita.events.EventBroker}
	 * Collection̕ύXʒm܂B
	 * @param gfc
	 */
	protected void notifyCollectionViewer(GameFrameController gfc) {
		CollectionEditor editor = gfc.getCollectionEditor();
	    for (CollectionMonitor viewer : gfc.getEventBroker().getListeners(CollectionMonitor.class)) {
	    	viewer.update(editor);
	    }
	}

	/**
	 * gfcActiveGameŌ̗vfɐ؂ւ܂B
	 * 
	 * @param gfc
	 */
	protected void changeForLastGame(GameFrameController gfc) {
		GameChangeCommand command = new GameChangeCommand(gfc.getCollectionEditor().size() - 1);
		gfc.getEventBroker().executeCommand(command);
	}
	/**
     * R}hs\ǂ`FbNāA
     * ɍ킹{@link org.eclipse.jface.action.Action#setEnabled(boolean)}
     * ݒ肵Ă܂B
     */
    private class Adapter implements 
    		WindowControllerListener, ControllerStatusMonitor, CollectionMonitor
    {
		/**
		 * 
		 */
		private Adapter() {
			super();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(AbstractRootGameTreeAction.this);
			}
			if (now != null) {
				now.getEventBroker().addView(AbstractRootGameTreeAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			setEnabled(isRunnable(now));
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			GameFrameController gfc = refGfc_.get();
			setEnabled(isRunnable(gfc));
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
		 */
		public void update(CollectionEditor collectionEditor) {
			GameFrameController gfc = refGfc_.get();
			setEnabled(isRunnable(gfc));
		}
    }

}
