/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ClearPlPropertyAction extends Action  implements Adaptable  {
	
	static private final Log log_s_ = LogFactory.getLog(ClearPlPropertyAction.class);

    /** u̎ԁv폜(&P) */
    static private final MessageResource CLB_NAME 
    		= new MessageResource(ClearPlPropertyAction.class, "clbName"); //$NON-NLS-1$

    private final Adapter adapter_;
    private WindowController controller_;
    /**
     * ۂɍ폜ΏۂƂȂvpeBłB
     */
    private Property target_;
    

    /**
	 * 
	 */
	public ClearPlPropertyAction() {
		super();
		adapter_ = new Adapter();
        controller_ = null;
        target_ = null;
        setText(CLB_NAME.get());
        setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}
	
	/**
     * R}hAł悤ɁAgԂ܂B
     */
    public ClearPlPropertyAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	
    	if (controller_ != null) {
    		controller_.removListener(adapter_);
    	}
    	controller_ = controller;
    	controller_.addListener(adapter_);
        return this;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		controller_.getActive().getEventBroker().executeCommand(
				new UpdateProperty(new Property[]{target_}, null, null));
	}

	/**
     */
    private class Adapter 
    		implements ControllerStatusMonitor, NodeMonitor,  WindowControllerListener 
    {

    	/**
    	 * ȑO{@link #changeActive(GameFrameController)}
    	 * w肳ꂽCX^XQƂŕێ܂B
    	 */
    	private Reference<GameFrameController> refGfc_;
    	
		/**
		 * 
		 */
		private Adapter() {
			super();
			refGfc_ = new WeakReference<GameFrameController>(null);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			GameFrameController gfc = refGfc_.get();
			if (gfc == null) {
				log_s_.warn("Lost GameFrameController (BUG)"); //$NON-NLS-1$
				return;
			}
			
			ArgumentChecker.throwIfNull(nodeView);
			target_ = nodeView.getProperty(SgfId.PLAYER_TO_PLAY);
			setEnabled(gfc.isEditMode() && null != target_);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(ClearPlPropertyAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			
            setEnabled(false);
			if (now != null) {
				now.getEventBroker().addView(ClearPlPropertyAction.this);
				currentChanged(now.getCollectionEditor().getActiveGame().getNodeList().getCurrentNodeView());
	        }
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			setEnabled(isEditMode);
		}
    }
}
