/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.RootGameTreeChooser;
import org.unitarou.yukinoshita.view.jface.dlg.RootGameTreeChooser.Style;

/**
 * ݔɂR}hłB<br>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ClearTrashCanAction extends AbstractRootGameTreeAction {
	/**
	 * uݔɂBv
	 */
	static private final MessageResource NT_CLEAR_TRASH_CAN
			= new MessageResource(ClearTrashCanAction.class, "ntClearTrashCan"); //$NON-NLS-1$
	
	/**
	 * uOK{^ƂݔɂȂAf[^͊SɎ܂Bv
	 */
	static private final MessageResource MSG_CONFIRMATION
			= new MessageResource(ClearTrashCanAction.class, "msgConfirmation"); //$NON-NLS-1$
	
	/**
	 * @param controller
	 */
	public ClearTrashCanAction(WindowController controller) {
		super(controller);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		Collection trashCan = FileManager.instance().getTrashCan();
		RootGameTreeChooser chooser = new RootGameTreeChooser(
				Display.getCurrent().getActiveShell(), 
				trashCan,
				Style.ANY);
		chooser.setShellTitle(NT_CLEAR_TRASH_CAN.get());
		chooser.setTitle(MSG_CONFIRMATION.get());
		if (IDialogConstants.CANCEL_ID == chooser.open()) {
			return;
		}
		
		FileManager.instance().clearTrashCan();
	}
	
	/**
	 * trueԂ܂B
	 * @see org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction#isRunnable(org.unitarou.yukinoshita.view.GameFrameController)
	 */
	@Override
	protected boolean isRunnable(GameFrameController now) {
		return true;
	}

}
