/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;

import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;

/**
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class CloseTabAction extends AbstractAction implements Adaptable {
	
	/** ut@Cv */
	static private final MessageResource LB_NO_NAME
			= new MessageResource(CloseTabAction.class, "lbNoName"); //$NON-NLS-1$

    private final Adapter adapter_;
    
    /**
	 * @param controller
	 */
	public CloseTabAction(WindowController controller) {
		super(controller);
		adapter_ = new Adapter();
		controller_.addListener(adapter_);
		setEnabled(false);
		setText(actionName_.get(LB_NO_NAME.get()));
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		controller_.closeActive();
		updateStateAndLabel();
	}
	
	private void updateStateAndLabel() {
		GameFrameController gfc = controller_.getActive();
		if (gfc == null) {
			setEnabled(false);
			setText(actionName_.get(LB_NO_NAME.get()));
			return;
		}
		setEnabled(true);
		File file = gfc.getCollection().getFile();
		String tabName = (file != null) ? file.getName() : LB_NO_NAME.get();
		setText(actionName_.get(tabName));
	}

    /**
     * 
     */
    private class Adapter implements WindowControllerListener {
		/**
		 * 
		 */
		private Adapter() {
			super();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			updateStateAndLabel();
		}
    }
}
