/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type;

/**
 * ݑIĂ{@link org.unitarou.yukinoshita.model.GameMediator}
 * ǗĂ{@link org.unitarou.sgf.RootGameTree}
 * w肳ꂽ{@link org.unitarou.sgf.Collection}ɕʂR}hłB<br>
 * ̏𖞂Ă鎞Ɏs\ɂȂ܂F<br>
 * 1. GameMediator݂B<br>
 * 2. CollectionɂPȏ{@link org.unitarou.sgf.RootGameTree}݂B<br>
 * 3. CollectionW(擪RootGameTreeDRILL)ȊOB<br>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class CopyRootGameTreeAction extends AbstractRootGameTreeAction {
	
	/**
	 *u{0}̃Rs[쐬Bv 
	 */
	static private final MessageResource NT_COPY
			= new MessageResource(CopyRootGameTreeAction.class, "ntCopy"); //$NON-NLS-1$
	
	/**
	 * u{0}̃Rs[w肵ĉBv 
	 */
	static private final MessageResource MSG_INSTRACTION
			= new MessageResource(CopyRootGameTreeAction.class, "msgInstraction"); //$NON-NLS-1$
	/**
	 * @param controller
	 */
	public CopyRootGameTreeAction(WindowController controller) {
		super(controller);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		EnumSet<Type> typeSet = getTypes();
		GameFrameController gfc = getGameFrameController();
		GameType gameType = gfc.getCollectionEditor().getActiveGame().getGameType(); 
		
		SelectTargetFileDialog dialog = new SelectTargetFileDialog(
				Display.getCurrent().getActiveShell(),
				typeSet);
		
		dialog.setShellTitle(NT_COPY.get(gameType.displayName()));
		dialog.setTitle(MSG_INSTRACTION.get(gameType.displayName()));
		int ret = dialog.open();
		if (ret == IDialogConstants.CANCEL_ID) {
			return;
		}
		GameFrameController target = dialog.getTarget();

		int activeGameIndex = gfc.getCollectionEditor().getActiveGameIndex();
		RootGameTree newRgt = new RootGameTree(gfc.getCollection().get(activeGameIndex));
		
		if (target == null) { // null̏ꍇ͐VKt@CɃRs[
			Collection collection = new Collection();
			collection.addLast(newRgt);
			controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), false);
			
			// 쐬͕ҏW[hɂB
			controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
			return;
		}
		
		// ̃t@CɃRs[
		CollectionEditor editor = target.getCollectionEditor();
		editor.createGame(newRgt);
		notifyCollectionViewer(target);			
		changeForLastGame(target);
	}

	/**
	 * ANVs\ȂƂ<code>true</code>Ԃ܂B<br>
	 * ̓Iɂ͈ȉ̏SĖĂ鎞ɃANV͎s\łF<br>
	 * 1. now<code>null</code><br>
	 * 2. nowɂPȏ{@link org.unitarou.sgf.RootGameTree}݂B<br>
	 * 3. nowW(擪RootGameTreeDRILL)ȊOB<br>
	 * 
	 * @param now
	 * @return
	 */
	@Override
	protected boolean isRunnable(GameFrameController now) {
		if (now == null) {
			return false;
		}
		Collection collection = now.getCollection();
		if (collection.size() < 1) {
			return false;
		}
		
		return !GameType.DRILL.equals(collection.get(0).getGameType());
	}

}
