/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.MenuItem;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.None;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/**
 * {@link org.unitarou.yukinoshita.view.jface.JFaceWindow}̃j[
 * SMenuManagerłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class JFaceMenuManager implements Adaptable {
	/** ut@C(&F)v */
	static private final MessageResource CLB_FILE 
			= new MessageResource(JFaceMenuManager.class, "clbFile"); //$NON-NLS-1$
	
	/** uVK쐬(&N)v */
	static private final MessageResource CLB_NEW_FILE 
			= new MessageResource(JFaceMenuManager.class, "clbNewFile"); //$NON-NLS-1$

	/** u(&G)v*/
	static private final MessageResource CLB_GAME
			= new MessageResource(JFaceMenuManager.class, "clbGame"); //$NON-NLS-1$

	/** ul(&P)v*/
	static private final MessageResource CLB_PROBLEM
			= new MessageResource(JFaceMenuManager.class, "clbProblem"); //$NON-NLS-1$

	/** u\Hv*/
	static private final MessageResource CLB_SIZE_19
			= new MessageResource(JFaceMenuManager.class, "clbSize.19"); //$NON-NLS-1$

	/** u\OHv*/
	static private final MessageResource CLB_SIZE_13
			= new MessageResource(JFaceMenuManager.class, "clbSize.13"); //$NON-NLS-1$

	/** uHv*/
	static private final MessageResource CLB_SIZE_9
			= new MessageResource(JFaceMenuManager.class, "clbSize.9"); //$NON-NLS-1$

	
	/** uݔ(&T)v */
	static private final MessageResource CLB_TRASH_CAN
			= new MessageResource(JFaceMenuManager.class, "clbTrashCan"); //$NON-NLS-1$


	/** uҏW(&E)v */
	static private final MessageResource CLB_EDIT 
			= new MessageResource(JFaceMenuManager.class, "clbEdit"); //$NON-NLS-1$
	
	/** uǖ(&P)v */
	static private final MessageResource CLB_POSITION
			= new MessageResource(JFaceMenuManager.class, "clbPosition"); //$NON-NLS-1$
	
	/** u(&M)v */
	static private final MessageResource CLB_MOVE
			= new MessageResource(JFaceMenuManager.class, "clbMove"); //$NON-NLS-1$

	/** u{0}:v */
	static private final MessageResource CLB_CURRENT_RGT1 
			= new MessageResource(JFaceMenuManager.class, "clbCurrentRgt1"); //$NON-NLS-1$

	/** u{0}u{1}v:v */
	static private final MessageResource CLB_CURRENT_RGT2 
			= new MessageResource(JFaceMenuManager.class, "clbCurrentRgt2"); //$NON-NLS-1$

	
	/** u\(&V)v */
	static private final MessageResource CLB_VIEW
			= new MessageResource(JFaceMenuManager.class, "clbView"); //$NON-NLS-1$
	
	/**
	 * uCAEg(&L)v
	 */
	static private final MessageResource CLB_LAYOUT
			= new MessageResource(JFaceMenuManager.class, "clbLayout"); //$NON-NLS-1$

	/** uc[(&T)v */
	static private final MessageResource CLB_TOOL
			= new MessageResource(JFaceMenuManager.class, "clbTool"); //$NON-NLS-1$

	/** uwv(&H)v */
	static private final MessageResource CLB_HELP
			= new MessageResource(JFaceMenuManager.class, "clbHelp"); //$NON-NLS-1$
	
	/**
	 * \j[Ő؂ւvoC_[K肵NXłB
	 */
	static private class ProviderInfo {
		private final Class<? extends Provider> clazz_;
		private final String displayName_;
		private ProviderInfo(Class<? extends Provider> clazz, String displayName) {
			clazz_ = clazz;
			displayName_ = displayName;
		}
	}

	/**
	 * \j[Ő؂ւvoC_[̈ꗗłB
	 */
	static private final ProviderInfo[] providerInfos_s_	= new ProviderInfo[]{
		new ProviderInfo(CoordinatesLabelProvider.class, CoordinatesLabelProvider.CONTEXT.displayName()),
		new ProviderInfo(StonePainter.class, StonePainter.CONTEXT.displayName()),
		new ProviderInfo(BlockLabelProvider.class, BlockLabelProvider.CONTEXT.displayName()),
		new ProviderInfo(VariationLabelProvider.class, VariationLabelProvider.CONTEXT.displayName()),
	};


	
	private final JFaceWindow window_;
	
	/**
	 * WI{bNX̐pɕێԃ}bvłB
	 * voC_[̃NXL[ɂ
	 * eProviderɕRÂĂActionێ܂B
	 */
	private final Map<Class, Action> providerMap_;
	
	/**
	 * WI{bNX̐pɕێԃ}bvłB
	 * voC_[C^[tFCX̃NXL[ɂāA
	 * ΉMenuManagerێ܂B
	 */
	private final Map<Class, MenuManager> providerInterfaceMenuMap_;
	
	
	
	/**
	 * ̃CX^X̕ύXʒmpCX^XłB
	 */
	private final Adapter adapter_;
	
	/**
	 * {@link #adapter_}Ăяo邽߃tB[hƂĕێĂ܂B
	 */
	private MenuManager editMenu_;
	
	/**
	 * {@link #adapter_}Ăяo邽߃tB[hƂĕێĂ܂B
	 */
	private MenuManager rgtEditMenu_;
	
    /**
     * 
     */
    public JFaceMenuManager(JFaceWindow window) {
        super();
        ArgumentChecker.throwIfNull(window);
        window_ = window;
        providerMap_ = new HashMap<Class, Action>();
        providerInterfaceMenuMap_ = new HashMap<Class, MenuManager>();
        adapter_ = new Adapter();
        window.addListener(adapter_);
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }
    
    /**
     * j[Ԃɐݒ肵܂B
     * WindowSɕ\ȂƐݒłȂڂ
     * Őݒ肵܂B
     */
    public void initialize() {
//        editMenu_.getMenu().getParentItem().setEnabled(false);
    }

    /**
     * menuManager烁j[\܂B
     * @param menuManager
     */
    public void createMenu(MenuManager menuManager) {
        createFileMenu(menuManager);
        createEditMenu(menuManager);
        createViewMenu(menuManager);
        createToolMenu(menuManager);
        createHelpMenu(menuManager);
    }


	/**
     * ut@C(F)vȉ̃j[쐬܂B
     */
    private void createFileMenu(MenuManager menuManager) {
        MenuManager fileMenu = new MenuManager(CLB_FILE.get());
        createNewFileMenu(fileMenu);
        fileMenu.add(new Separator());
        fileMenu.add(new OpenFileAction().setController(window_));
        fileMenu.add(new OpenFromClipboard().setController(window_));
        fileMenu.add(new OpenFromWebSite(window_));
        fileMenu.add(new CloseTabAction(window_));
        fileMenu.add(new CloseAllTabAction(window_));
        fileMenu.add(new Separator());
        fileMenu.add(new SaveAction().setController(window_));
        fileMenu.add(new SaveAsAction().setController(window_));
        fileMenu.add(new Separator());
        createTrashCanMenu(fileMenu);
        fileMenu.add(new Separator());
        fileMenu.add(new CreateWindowAction());
        fileMenu.add(new Separator());
        fileMenu.add(new ExitAction());
        menuManager.add(fileMenu);
    }
    

	/**
     * parent̎qƂĐVK쐬̃Tuj[쐬܂B
	 * @param fileMenu
	 */
	private void createNewFileMenu(MenuManager parent) {
		MenuManager menu = new MenuManager(CLB_NEW_FILE.get());
		createNewGameFileMenu(menu);
		createNewProblemFileMenu(menu);
		menu.add(new NewDrillFileAction().setController(window_));
		parent.add(menu);
	}


	/**
     * parent̎qƂĊ̐VK쐬̃Tuj[쐬܂B
	 * @param fileMenu
	 */
	private void createNewGameFileMenu(MenuManager parent) {
		MenuManager menu = new MenuManager(CLB_GAME.get());
		
		//TODO ReLXg
		MenuManager submenu;
		submenu = new MenuManager(CLB_SIZE_19.get());
		createNewGameFileAndHandicapMenu(submenu, SgfSize.create(19, 19), 9);
		menu.add(submenu);
		
		submenu = new MenuManager(CLB_SIZE_13.get());
		createNewGameFileAndHandicapMenu(submenu, SgfSize.create(13, 13), 6);
		menu.add(submenu);
		
		submenu = new MenuManager(CLB_SIZE_9.get());
		createNewGameFileAndHandicapMenu(submenu, SgfSize.create(9, 9), 4);
		menu.add(submenu);

		parent.add(menu);
	}
	
	/**
	 * parent̎qƂsgfSizěՂ
	 * ݐ`maxHandicap܂ł̃nfBLbvw肷郁j[쐬܂B
	 * @param parent
	 * @param sgfSize
	 * @param maxHandicap
	 */
	private void createNewGameFileAndHandicapMenu(
			MenuManager parent, SgfSize sgfSize, int maxHandicap) 
	{
		for (int i = 0; i <= maxHandicap; ++i) {
			parent.add(new NewGameFileAction(sgfSize, i).setController(window_));
		}
	}


    /**
     * parent̎qƂċl̐VK쐬̃Tuj[쐬܂B
	 * @param parent
	 */
	private void createNewProblemFileMenu(MenuManager parent) {
		MenuManager menu = new MenuManager(CLB_PROBLEM.get());
		
		//TODO ReLXg
		MenuManager submenu;
		submenu = new MenuManager(CLB_SIZE_19.get());
		createNewProblemFileAndPlayerToPlayMenu(submenu, SgfSize.create(19, 19));
		menu.add(submenu);
		
		submenu = new MenuManager(CLB_SIZE_13.get());
		createNewProblemFileAndPlayerToPlayMenu(submenu, SgfSize.create(13, 13));
		menu.add(submenu);
		
		submenu = new MenuManager(CLB_SIZE_9.get());
		createNewProblemFileAndPlayerToPlayMenu(submenu, SgfSize.create(9, 9));
		menu.add(submenu);

		parent.add(menu);	
	}
	
	/**
	 * parent̎qƂsizěłōAw肷郁j[쐬܂B
	 * @param parent
	 * @param size
	 */
	private void createNewProblemFileAndPlayerToPlayMenu(MenuManager parent, SgfSize sgfSize) {
		parent.add(new NewProblemFileAction(sgfSize, SgfColor.BLACK).setController(window_));
		parent.add(new NewProblemFileAction(sgfSize, SgfColor.WHITE).setController(window_));
	}

    /**
     * parent̎qƂĂݔ̃Tuj[쐬܂B
	 * @param parent
	 */
	private void createTrashCanMenu(MenuManager parent) {
		MenuManager menu = new MenuManager(CLB_TRASH_CAN.get());
		menu.add(new SalvageFromTrashCanAction(window_));
		menu.add(new ClearTrashCanAction(window_));
		parent.add(menu);
	}

	
	/**
     * uҏW(E)vȉ̃j[쐬܂B
     */
    private void createEditMenu(MenuManager menuManager) {
        editMenu_ = new MenuManager(CLB_EDIT.get());
        editMenu_.add(new UndoAction().setController(window_));
        editMenu_.add(new RedoAction().setController(window_));
        editMenu_.add(new Separator());
        createPositionValueMenu(editMenu_);
        createMoveValueMenu(editMenu_);
        editMenu_.add(new ClearPlPropertyAction().setController(window_));
        editMenu_.add(new RemoveNodeAction().setController(window_));
        editMenu_.add(new Separator());
        editMenu_.add(new SetVwAtRootAction(window_));
        editMenu_.add(new UnsetVwAtRootAction(window_));
        editMenu_.add(new Separator());
        createRootGameTreeEditMenu(editMenu_);
        editMenu_.addMenuListener(new IMenuListener() {
            public void menuAboutToShow(IMenuManager manager) {
                updateMenu();
            }
        });
        menuManager.add(editMenu_);
    }
    
	/**
     * parenteƂċǖʂ̕]ݒ肷郁j[쐬܂B
	 * @param parent
	 */
	private void createPositionValueMenu(MenuManager parent) {
		MenuManager menu = new MenuManager(CLB_POSITION.get());
		menu.add(new SetPositionValueAction(window_, SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetPositionValueAction(window_, SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL)));
		menu.add(new SetPositionValueAction(window_, SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetPositionValueAction(window_, SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL)));
		menu.add(new SetPositionValueAction(window_, SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetPositionValueAction(window_, SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL)));
		menu.add(new SetPositionValueAction(window_, SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetPositionValueAction(window_, SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL)));
		menu.add(new Separator());
        menu.add(new SetPositionValueAction(window_, SgfId.HOTSPOT.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetPositionValueAction(window_, SgfId.HOTSPOT.makeProperty(SgfDouble.NORMAL)));
		menu.add(new Separator());
		menu.add(new SetPositionValueAction(window_, null));
		parent.add(menu);
	}

	/**
     * parenteƂĒ̕]ݒ肷郁j[쐬܂B
	 * @param parent
	 */
	private void createMoveValueMenu(MenuManager parent) {
		MenuManager menu = new MenuManager(CLB_MOVE.get());
		menu.add(new SetMoveValueAction(window_, SgfId.TESUJI.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetMoveValueAction(window_, SgfId.TESUJI.makeProperty(SgfDouble.NORMAL)));
		menu.add(new SetMoveValueAction(window_, SgfId.BAD_MOVE.makeProperty(SgfDouble.EMPHASIZED)));
		menu.add(new SetMoveValueAction(window_, SgfId.BAD_MOVE.makeProperty(SgfDouble.NORMAL)));
		menu.add(new SetMoveValueAction(window_, SgfId.INTERESTING.makeProperty(None.INSTANCE)));
		menu.add(new SetMoveValueAction(window_, SgfId.DOUBTFUL.makeProperty(None.INSTANCE)));
		menu.add(new Separator());
		menu.add(new SetMoveValueAction(window_, null));
		parent.add(menu);
		
	}

    /**
     * parenteƂRootGameTreê̂𕡎ʁEړEj郁j[쐬܂B
	 * @param parent
	 */
	private void createRootGameTreeEditMenu(MenuManager parent) {
		rgtEditMenu_ = new MenuManager(CLB_CURRENT_RGT1.get());
		rgtEditMenu_.add(new CopyRootGameTreeAction(window_));
		rgtEditMenu_.add(new MoveRootGameTreeAction(window_));
		rgtEditMenu_.add(new RemoveRootGameTreeAction(window_));
		parent.add(rgtEditMenu_);
	}

	/**
     * u\(V)vȉ̃j[쐬܂B
     */
    private void createViewMenu(MenuManager menuManager) {
        MenuManager viewMenu = new MenuManager(CLB_VIEW.get());
        for (ProviderInfo info : providerInfos_s_) {
        	composeProviderMenu(viewMenu, info.clazz_, info.displayName_);
        }
        viewMenu.add(new Separator());
        viewMenu.add(createLayoutMenu());
        viewMenu.add(new ShowSgfText(window_));
        viewMenu.addMenuListener(new IMenuListener() {
            public void menuAboutToShow(IMenuManager manager) {
                updateMenu();
            }
        });
        menuManager.add(viewMenu);
    }
    
	/**
	 * evoC_[̑Ij[쐬܂B
	 * @param <T>
	 * @param parentMenu ẽj[łB
	 * @param menuManager o^郁j[łB
	 * @param providerMap_ {@link #providerMap_}łB
	 * @param clazz voC_[̃NXłB
	 */
	private <T extends Provider> void composeProviderMenu(
			MenuManager parentMenu, Class<T> clazz, String displayName) 
	{
		MenuManager menuManager = new MenuManager(displayName); 
		providerInterfaceMenuMap_.put(clazz, menuManager);
    	for (T provider : Yukinoshita.context().getProviders(clazz)) {
            SelectProviderAction<T> action = new SelectProviderAction<T>(clazz, provider);
            action.setController(window_);
            menuManager.add(action);
            providerMap_.put(provider.getClass(), action);
    	}		
    	parentMenu.add(menuManager);
	}

	/**
	 * CAEg(L)ȉ̃j[쐬܂B
	 * @return
	 */
	private MenuManager createLayoutMenu() {
		MenuManager menuManager = new MenuManager(CLB_LAYOUT.get());
		menuManager.add(new LoadLayoutAction(window_));
		menuManager.add(new DefaultLayoutAction(window_));
		menuManager.add(new Separator());
		menuManager.add(new SaveLayoutAction(window_));
		return menuManager;
	}
	/**
     * uc[(T)vȉ̃j[쐬܂B
	 * @param menuManager
	 */
	private void createToolMenu(MenuManager menuManager) {
        MenuManager fileMenu = new MenuManager(CLB_TOOL.get());
        fileMenu.add(new OpenPreferenceAction((JFaceContext)Yukinoshita.context()));
        menuManager.add(fileMenu);
	}

	/**
     * uwv(H)vȉ̃j[쐬܂B
     */
    private void createHelpMenu(MenuManager menuManager) {
        MenuManager fileMenu = new MenuManager(CLB_HELP.get());
        fileMenu.add(new AboutAction());
        menuManager.add(fileMenu);
    }

    /**
     * gfc̏ԂɉĎ̃j[̏ԂXV܂B
     * <ol>
     *   <li>REDO/UNDOj[̍ږƗL^</li>
     *   <li>W\̑I{^<li>
     *   <li>΂̃x̑I{^</li>
     * </ol>
     * nullݒ肷ƁAꂼꖳ܂B
     * 
     * @param gfc
     */
    private void updateMenu() {
    	GameFrameController gfc = window_.getActive();
    	MenuItem menuItem = rgtEditMenu_.getMenu().getParentItem();
       if (gfc == null) {
        	menuItem.setText("t@C܂");
        	menuItem.setEnabled(false);
            return;
        }
        String label;
        GameMediator gameMediator = gfc.getCollectionEditor().getActiveGame();
        RootGameTree rgt = gameMediator.getRootGameTree();
        RootGameTreeLabelProvider provider = RootGameTreeLabelProvider.CONTEXT.defaultProvider();
        String name = provider.getLabel(rgt);
        if (name.length() != 0) {
        	label = CLB_CURRENT_RGT2.get(rgt.getGameType().displayName(), name);
        } else {
        	provider = new GreedyRgtLabelProvider();
        	name = provider.getLabel(rgt);
        	label = CLB_CURRENT_RGT1.get(name);
        }
        menuItem.setText(label);
        menuItem.setEnabled(true);
        
        for (ProviderInfo info : providerInfos_s_) {
        	changeRadioState(gfc, info.clazz_);
        }
    }

    /**
     * voC_̑I{^Agfc擾ł錻݂̐ݒlɑΉčXV܂B
     */
    private <T extends Provider> void changeRadioState(
    		GameFrameController gfc, Class<T> clazz) 
    {
        IAction action = providerMap_.get(gfc.getProvider(clazz).getClass());
        IContributionItem[] items = providerInterfaceMenuMap_.get(clazz).getItems();
        for (int i = 0; i < items.length; ++i) {
            ((ActionContributionItem)items[i]).getAction().setChecked(false);
        } 	
        if (action != null) {
            action.setChecked(true);
        }
    }

    /**
     * CX^Xp郊Xi[AA_v^[܂Ƃ߂NXłB 
     */
    private class Adapter 
    		implements NodeMonitor, ModelEventNotifier, ControllerStatusMonitor, WindowControllerListener 
    {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(JFaceMenuManager.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(JFaceMenuManager.this);
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
//            editMenu_.getMenu().getParentItem().setEnabled(isEditMode);
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase phase) {
            // Ȃ
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			updateMenu();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			updateMenu();
		}
    }
}
