/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type;

/**
 * ݑIĂ{@link org.unitarou.yukinoshita.model.GameMediator}
 * ǗĂ{@link org.unitarou.sgf.RootGameTree}
 * w肳ꂽ{@link org.unitarou.sgf.Collection}ɈړR}hłB<br>
 * ̏𖞂Ă鎞Ɏs\ɂȂ܂F<br>
 * 1. GameMediator݂B<br>
 * 2. GameMediatorҏW[hłB<br>
 * 3. CollectionɂQȏ{@link org.unitarou.sgf.RootGameTree}݂B<br>
 * 4. CollectionW(擪RootGameTreeDRILL)ȊOB<br>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class MoveRootGameTreeAction extends AbstractRootGameTreeAction {
	
	/**
	 *u{0}ʃt@CɈړBv 
	 */
	static private final MessageResource NT_MOVE
			= new MessageResource(MoveRootGameTreeAction.class, "ntMove"); //$NON-NLS-1$
	
	/**
	 * u{0}̈ړw肵ĉBv 
	 */
	static private final MessageResource MSG_INSTRACTION
			= new MessageResource(MoveRootGameTreeAction.class, "msgInstraction"); //$NON-NLS-1$

	/**
	 * @param controller
	 */
	public MoveRootGameTreeAction(WindowController controller) {
		super(controller);
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		EnumSet<Type> typeSet = getTypes();
		GameFrameController gfc = getGameFrameController();
		GameType gameType = gfc.getCollectionEditor().getActiveGame().getGameType(); 
		
		SelectTargetFileDialog dialog = new SelectTargetFileDialog(
				Display.getCurrent().getActiveShell(),
				typeSet);
		
		dialog.setShellTitle(NT_MOVE.get(gameType.displayName()));
		dialog.setTitle(MSG_INSTRACTION.get(gameType.displayName()));
		int ret = dialog.open();
		if (ret == IDialogConstants.CANCEL_ID) {
			return;
		}
		GameFrameController target = dialog.getTarget();

		int activeGameIndex = gfc.getCollectionEditor().getActiveGameIndex();
		RootGameTree newRgt = gfc.getCollection().get(activeGameIndex);
		boolean finishTransaction = false;
		//gUNVX^[g
		try {
			if (target == null) { // null̏ꍇ͐VKt@CɈړ
				Collection collection = new Collection();
				collection.addLast(newRgt);
				controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), true);
				
				// 쐬͕ҏW[hɂB
				controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
				finishTransaction = true;
				return;
			}
			
			// ̃t@CɈړ
			CollectionEditor editor = target.getCollectionEditor();
			editor.createGame(newRgt);
			notifyCollectionViewer(target);			
			changeForLastGame(target);
			finishTransaction = true;
			
		} finally {
			// ړɐiKŁÃt@C폜
			if (finishTransaction) {
				gfc.getCollectionEditor().remove(activeGameIndex);
				notifyCollectionViewer(gfc);
				changeForLastGame(gfc);
			}
		}
	}
}
