/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.action.Action;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;

/**
 * VKɖW쐬ANVłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class NewDrillFileAction extends Action {

    /** W */
    static private final MessageResource CLB_NAME 
    		= new MessageResource(NewDrillFileAction.class, "clbName"); //$NON-NLS-1$
    
    /**
     * ANVsΏۂ̃Rg[[łB 
     */
    private WindowController controller_;
    
    /**
	 * 
	 */
	public NewDrillFileAction() {
		super();
		controller_ = null;
		setText(CLB_NAME.get());
	}

    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public NewDrillFileAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	controller_ = controller;
        return this;
    }
	
    /* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		Collection collection = new Collection();
		RootGameTree rgt = RootGameTreeFactory.createDrill();
		rgt.setApplication(
				Application.create(
						Yukinoshita.instance().getName(), 
						Yukinoshita.instance().getVersion()));
		collection.addLast(rgt);
		controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), false);

		// 쐬͕ҏW[hɂB
		controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
	}
}
