/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class NewProblemFileAction extends Action {
	

	/**
	 * uVKɋl쐬Bv
	 */
	static private final MessageResource NT_DLG_TITLE
			= new MessageResource(NewProblemFileAction.class, "ntDlgTitle"); //$NON-NLS-1$
	
	/**
	 * uVKɍ쐬l̒ǉw肵ĉBv
	 */
	static private final MessageResource MSG_INSTRACTION
			= new MessageResource(NewProblemFileAction.class, "msgInstraction"); //$NON-NLS-1$

	/** {0} */
    static private final MessageResource CLB_NAME 
    		= new MessageResource(NewProblemFileAction.class, "clbName"); //$NON-NLS-1$
    
	private final SgfSize sgfSize_;
	private final SgfColor playerToPlay_;

	/**
     * ANVsΏۂ̃Rg[[łB 
     */
    private WindowController controller_;
    
    /**
	 * 
	 */
	public NewProblemFileAction(SgfSize sgfSize, SgfColor playerToPlay) {
		super();
		ArgumentChecker.throwIfNull(sgfSize, playerToPlay);
		sgfSize_ = sgfSize;
		playerToPlay_ = playerToPlay;
		controller_ = null;
		setText(CLB_NAME.get(playerToPlay_.displayName()));
	}

    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public NewProblemFileAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	controller_ = controller;
        return this;
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		RootGameTree newRgt = RootGameTreeFactory.createProblem(sgfSize_, playerToPlay_);
		newRgt.setApplication(
				Application.create(
						Yukinoshita.instance().getName(), 
						Yukinoshita.instance().getVersion()));

		GameFrameController target = null;
		if (controller_.getGameFrameControllers().length != 0) {
			SelectTargetFileDialog dialog = new SelectTargetFileDialog(
					Display.getCurrent().getActiveShell(),
					EnumSet.of(Type.PERMITS_NEW_FILE, Type.PERMITS_PROBLEM));
			
			dialog.setShellTitle(NT_DLG_TITLE.get());
			dialog.setTitle(MSG_INSTRACTION.get());
			int ret = dialog.open();
			if (ret == IDialogConstants.CANCEL_ID) {
				return;
			}
			target = dialog.getTarget();
		}
		
		if (target == null) {
			Collection collection = new Collection();
			collection.addLast(newRgt);
			controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), false);
			
			// 쐬͕ҏW[h{SETUP[hɂB
			EventBroker broker = controller_.getActive().getEventBroker();
			broker.executeCommand(new ChangeEditModeCommand(true));
			broker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
			return;
		}

		CollectionEditor editor = target.getCollectionEditor();
		editor.createGame(newRgt);
        for (CollectionMonitor viewer : target.getEventBroker().getListeners(CollectionMonitor.class)) {
        	viewer.update(editor);
        }
        
		EventBroker broker = target.getEventBroker();
		broker.executeCommand(new GameChangeCommand(editor.size() - 1));
		broker.executeCommand(new ChangeEditModeCommand(true));
		broker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
	}
}
