/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser.Style;

/**
 * ut@CJvANVłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class OpenFileAction extends Action {
    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(OpenFileAction.class);

    
    /** t@CJ(&O)@Ctrl+O */
    static private final MessageResource CLB_NAME 
    		= new MessageResource(OpenFileAction.class, "clbName"); //$NON-NLS-1$

	/**
     * ANVsΏۂ̃Rg[[łB 
     */
    private WindowController controller_;
    
    /**
     * 
     */
    public OpenFileAction() {
        super();
        controller_ = null;
        setText(CLB_NAME.get());
    }


    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public OpenFileAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	controller_ = controller;
        return this;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.action.IAction#run()
     */
    @Override
	public void run() {
        if (controller_ == null) {
        	log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored."); //$NON-NLS-1$
            return;
        }
		IgoFileDialog dialog = new IgoFileDialog(
				Display.getCurrent().getActiveShell(), Style.OPEN_FILES);
		dialog.open();
		for (File file : dialog.getFiles()) {
		    //TODO ̃t@CAċ󂯂Ƃ
		    //      炩̃}WbNio[ɉăvOXo[oׂB
			
		    // [Ȃꍇ̓bZ[Woăt@CJȂB
		    if (!Yukinoshita.instance().checkFreeMemory()) {
		        return;
		    }
			openFileImpl(file);
		}
    }

	private void openFileImpl(File file) {
		Collection collection = FileManager.instance().open(file);
		if (collection == null) {
			return;
		}
		controller_.register(collection, null, false);
	}
}
