/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

import org.unitarou.lang.Logging;
import org.unitarou.lang.Logging.Level;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.Application.MessageLevel;
import org.unitarou.yukinoshita.view.WindowController;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class OpenFromClipboard extends Action {
    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(OpenFromClipboard.class);

    
    /** Nbv{[hǂݍ(&C)@Ctrl+V*/
    static private final MessageResource CLB_NAME 
    		= new MessageResource(OpenFromClipboard.class, "clbName"); //$NON-NLS-1$

    /** Nbv{[h */
    static private final MessageResource LB_CLIPBOARD 
    		= new MessageResource(OpenFromClipboard.class, "lbClipboard"); //$NON-NLS-1$

    /** Nbv{[h̓ǂݍ݂Ɏs܂B*/
    static private final MessageResource NT_CLIPBOARD_READ_FAILURE 
    		= new MessageResource(OpenFromClipboard.class, "ntClipboardReadFailure"); //$NON-NLS-1$

    /** Nbv{[h̒geLXg`ł͂܂łB*/
    static private final MessageResource MSG_NO_TEXT_CONTENTS 
    		= new MessageResource(OpenFromClipboard.class, "msgNoTextContents"); //$NON-NLS-1$

    /** Nbv{[h̒gɊf[^܂łB*/
    static private final MessageResource MSG_NO_CONTENTS 
    		= new MessageResource(OpenFromClipboard.class, "msgNoContents"); //$NON-NLS-1$

    /** Nbv{[h̒gSGFt@CƂēǂݍ߂܂łB*/
    static private final MessageResource MSG_SGF_PARSE_ERROR 
    		= new MessageResource(OpenFromClipboard.class, "msgSgfParseError"); //$NON-NLS-1$

    /**
     * ANVsΏۂ̃Rg[[łB 
     */
    private WindowController controller_;
    
    /**
     * 
     */
    public OpenFromClipboard() {
        super();
        controller_ = null;
        setText(CLB_NAME.get());
    }

    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public OpenFromClipboard setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	controller_ = controller;
        return this;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	@Logging(level=Level.TRACE, 
			 contents="Nbv{[h̃y[XgΏۂƂȂĂRg[")
    public void run() {
        if (controller_ == null) {
        	log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored."); //$NON-NLS-1$
            return;
        }
        Display display = Display.getCurrent();
        Control control = display.getFocusControl();
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("Target control: " + control); //$NON-NLS-1$
        }

    	if (pasteToControl(control)) {
    		return;
    	}
		Clipboard cb = new Clipboard(display);
        try {
    		Transfer transfer = TextTransfer.getInstance();
    		TransferData[] available = cb.getAvailableTypes();
    		for (int i = 0; i < available.length; i++) {
    			if (transfer.isSupportedType(available[i])) {
    				String data = (String)cb.getContents(transfer);
    				openFromClipboardImpl(data);
    				return;
    			}
    		}	
        	Yukinoshita.application().openMessageDialog(
        			MessageLevel.WARNING,
        			NT_CLIPBOARD_READ_FAILURE.get(),
        			MSG_NO_TEXT_CONTENTS.get());

        } catch (SgfParserException e) {
        	Yukinoshita.application().openMessageDialog(
        			MessageLevel.INFORMATION,
        			NT_CLIPBOARD_READ_FAILURE.get(),
        			MSG_SGF_PARSE_ERROR.get());
        } finally {
        	cb.dispose();
        }
    }
	
	/**
	 * controlɃy[XgłtrueԂ܂B<br>
	 * ȊÔƂSGFt@C̓ǂݍ݂Ƃ݂Ȃ܂B
	 * 
	 * @param control
	 * @return
	 */
	private boolean pasteToControl(Control control) {
		if (control == null) {
			return false;
		}
		if (control instanceof Text) {
			Text text = (Text)control;
			if (text.getEditable()) {
				text.paste();
				return true;
			}
		}
		if (control instanceof Combo) {
			Combo combo = (Combo)control;
			if (0 == (combo.getStyle() & SWT.READ_ONLY)) {
				combo.paste();
				return true;
			}
		}
		return false;
	}
	
	
	private void openFromClipboardImpl(String data) throws SgfParserException {
		SgfParser sgfParser = new SgfParser();
		Collection collection = sgfParser.parse(data);
		if (collection.size() == 0) {
        	Yukinoshita.application().openMessageDialog(
        			MessageLevel.INFORMATION,
        			NT_CLIPBOARD_READ_FAILURE.get(),
        			MSG_NO_CONTENTS.get());
        	return;
		}
		controller_.register(collection, LB_CLIPBOARD.get(), false);
	}
}
