/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;

import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.DownloadDialog;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class OpenFromWebSite extends AbstractAction {

	/**
	 * @param controller
	 */
	public OpenFromWebSite(WindowController controller) {
		super(controller);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		DownloadDialog dialog = new DownloadDialog(Display.getCurrent().getActiveShell());
		if (dialog.open() == Window.OK) {
			controller_.register(dialog.getCollection(), "Web site", false);
		}
	}
}
