/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;

import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.pref.BoardPreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.FilePreferencePage;

/**
 * uݒ(P)vANVłB
 * {@link org.eclipse.jface.preference.PreferenceDialog}J܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class OpenPreferenceAction extends Action {

    /** ݒ(&P)... */
    static private final MessageResource CLB_Name 
    		= new MessageResource(OpenPreferenceAction.class, "clbName"); //$NON-NLS-1$

    private final JFaceContext context_;
    /**
	 * 
	 */
	public OpenPreferenceAction(JFaceContext context) {
		super();
		ArgumentChecker.throwIfNull(context);
        setText(CLB_Name.get());
        setEnabled(true);
        context_ = context;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		PreferenceManager pm = new PreferenceManager();
		pm.addToRoot(BoardPreferencePage.createPreferenceNode());
		pm.addToRoot(FilePreferencePage.createPreferenceNode());
		PreferenceDialog dialog = new PreferenceDialog(null, pm);
		
		dialog.setPreferenceStore(context_);
		dialog.open();
	}
}
