/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.RemoveCurrentNode;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

/**
 * ݑIĂm[h폜ANVłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RemoveNodeAction extends Action implements Adaptable {
	
	static private final Log log_s_ = LogFactory.getLog(RemoveNodeAction.class);

    /** m[h{0}폜 */
    static private final MessageResource CLB_NAME 
    		= new MessageResource(RemoveNodeAction.class, "clbName"); //$NON-NLS-1$
    
    private final Adapter adapter_;
    private WindowController controller_;
	/**
	 * 
	 */
	public RemoveNodeAction() {
		super();
		adapter_ = new Adapter();
        controller_ = null;
        setCommandName(Strings.EMPTY);
        setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}
	
	private void setCommandName(String name) {
		String param = name.trim();
		if (param.length() != 0) {
			param = '(' + param + ')';
		}
        setText(CLB_NAME.get(param));
	}

	/**
     * R}hAł悤ɁAgԂ܂B
     */
    public RemoveNodeAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	
    	if (controller_ != null) {
    		controller_.removListener(adapter_);
    	}
    	controller_ = controller;
    	controller_.addListener(adapter_);
        return this;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		
		GameFrameController gfc = controller_.getActive();
		NodeList nodeList = gfc.getCollectionEditor().getActiveGame().getNodeList();
		if (nodeList.getLastNodeView() == nodeList.getCurrentNodeView()) {
			gfc.getEventBroker().executeCommand(new RemoveLastNode());
		} else {
			gfc.getEventBroker().executeCommand(new RemoveCurrentNode());
		}
	}

	/**
     */
    private class Adapter 
    		implements ControllerStatusMonitor, NodeMonitor, WindowControllerListener 
    {
    	/**
    	 * ȑO{@link #changeActive(GameFrameController)}
    	 * w肳ꂽCX^XQƂŕێ܂B
    	 */
    	private Reference<GameFrameController> refGfc_;
    	
		/**
		 * 
		 */
		private Adapter() {
			super();
			refGfc_ = new WeakReference<GameFrameController>(null);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			GameFrameController gfc = refGfc_.get();
			if (gfc == null) {
				log_s_.warn("Lost GameFrameController (BUG)"); //$NON-NLS-1$
				return;
			}
			ArgumentChecker.throwIfNull(nodeView);
			setCommandName(NodeViewLabelProvider.CONTEXT.defaultProvider().getLabel(nodeView));
			setEnabled(isValidState(gfc));
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(RemoveNodeAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			GameFrameController gfc = refGfc_.get();
			if (gfc != null) {
				now.getEventBroker().addView(RemoveNodeAction.this);
			}
			if (isValidState(gfc)) {
				setEnabled(true);

			} else {
	            setEnabled(false);
	            setCommandName(Strings.EMPTY);
	            return;
	        }
		}
		
		/**
		 * gfcɑ΂ăm[h̍폜\ȏꍇtrueԂ܂B<br>
		 * 폜\ȏԂƂ́F
		 * 1.gfc݂inulljA
		 * 2.gfč݂NodeListɗvf2ȏ゠B
		 * 3.ݕ\Ăm[h擪ł͂ȂB
		 * łB
		 * @param gfc
		 * @return
		 */
		private boolean isValidState(GameFrameController gfc) {
			if (gfc == null) {
				return false;
			}
			NodeList nodeList = gfc.getCollectionEditor().getActiveGame().getNodeList();
			if (nodeList.size() <= 1) {
				return false;
			}
			if (nodeList.getCurrentNodeView() == nodeList.getNodeView(0)) {
				return false;
			}
			
			return gfc.isEditMode();
		}
		
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			setEnabled(isEditMode);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}
    }
}
