/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.RootGameTree;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RemoveRootGameTreeAction extends AbstractRootGameTreeAction {

	/**
	 * ̃NX̃K[łB
	 */
	static private final Log log_s_ = LogFactory.getLog(RemoveRootGameTreeAction.class);

	/**
	 * @param controller
	 */
	public RemoveRootGameTreeAction(WindowController controller) {
		super(controller);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.act.MoveRootGameTreeAction#run()
	 */
	@Override
	public void run() {
		GameFrameController gfc = getGameFrameController();
		if (gfc == null) { //OłȂGCꂽB
			log_s_.warn("Lost gameFrameController (Maybe BUG)."); //$NON-NLS-1$
			return;
		}
		
		CollectionEditor ce = gfc.getCollectionEditor();
		int activeIndex = ce.getActiveGameIndex();
		RootGameTree rgt = ce.getActiveGame().getRootGameTree();
		FileManager.instance().drop(rgt);
		ce.remove(activeIndex);
		notifyCollectionViewer(gfc);
		changeForLastGame(gfc);
	}
}
