/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.dlg.RootGameTreeChooser;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.jface.dlg.RootGameTreeChooser.Style;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog.Type;

/**
 * ݔR}hłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SalvageFromTrashCanAction extends AbstractRootGameTreeAction {

	/**
	 * uݔBv
	 */
	static private final MessageResource NT_SALVAGE_DLG_TITLE
			= new MessageResource(SalvageFromTrashCanAction.class, "ntSalvageDlgTitle"); //$NON-NLS-1$
	
	/**
	 * uݔoIĂBv
	 */
	static private final MessageResource MSG_SALVAGE_INSTRACTION
			= new MessageResource(SalvageFromTrashCanAction.class, "msgSalvageInstraction"); //$NON-NLS-1$

	/**
	 * u{0}ݔڂBv
	 */
	static private final MessageResource NT_MOVE_DLG_TITLE
			= new MessageResource(SalvageFromTrashCanAction.class, "ntMoveDlgTitle"); //$NON-NLS-1$
	
	/**
	 * u{0}̈ړw肵ĉBv
	 */
	static private final MessageResource MSG_MOVE_INSTRACTION
			= new MessageResource(SalvageFromTrashCanAction.class, "msgMoveInstraction"); //$NON-NLS-1$

	/**
	 * @param controller
	 */
	public SalvageFromTrashCanAction(WindowController controller) {
		super(controller);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		Collection trashCan = FileManager.instance().getTrashCan();
		RootGameTreeChooser chooser = new RootGameTreeChooser(
				Display.getCurrent().getActiveShell(), 
				trashCan,
				Style.SINGLE);
		chooser.setShellTitle(NT_SALVAGE_DLG_TITLE.get());
		chooser.setTitle(MSG_SALVAGE_INSTRACTION.get());
		if (IDialogConstants.CANCEL_ID == chooser.open()) {
			return;
		}
		
		RootGameTree[] selected = chooser.getSelected();
		if (0 == selected.length) {
			return;
		}
		RootGameTree target = selected[0];
		
		EnumSet<Type> typeSet = getTypes();
		SelectTargetFileDialog dialog = new SelectTargetFileDialog(
				Display.getCurrent().getActiveShell(),
				typeSet);
		
		String gameTypeName = target.getGameType().displayName();
		dialog.setShellTitle(NT_MOVE_DLG_TITLE.get(gameTypeName));
		dialog.setTitle(MSG_MOVE_INSTRACTION.get(gameTypeName));
		if (dialog.open() == IDialogConstants.CANCEL_ID) {
			return;
		}

		GameFrameController gfc = dialog.getTarget();
		boolean finishTransaction = false;
		//gUNVX^[g
		try {
			if (gfc == null) { // null̏ꍇ͐VKt@CɈړ
				Collection collection = new Collection();
				collection.addLast(target);
				controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), true);
				
				// 쐬͕ҏW[hɂB
				controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
				finishTransaction = true;
				return;
			}
			
			// ̃t@CɈړ
			CollectionEditor editor = gfc.getCollectionEditor();
			editor.createGame(target);
			notifyCollectionViewer(gfc);			
			changeForLastGame(gfc);
			finishTransaction = true;
			
		} finally {
			// ړɐiKŁAݔ폜
			if (finishTransaction) {
				for (int i = 0; i < trashCan.size(); ++i) {
					if (target.equals(trashCan.get(i))) {
						FileManager.instance().pickUp(i);
						break;
					}
				}
			}
		}
	}

	/**
	 * trueԂ܂B
	 * @see org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction#isRunnable(org.unitarou.yukinoshita.view.GameFrameController)
	 */
	@Override
	protected boolean isRunnable(GameFrameController now) {
		return true;
	}
}
