/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SaveAction extends Action implements Adaptable {
    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(SaveAction.class);

    
    /** ۑ(&S)@Ctrl+S */
    static private final MessageResource CLB_Name 
    		= new MessageResource(SaveAction.class, "clbName"); //$NON-NLS-1$

	/**
     * ANVsΏۂ̃Rg[[łB 
     */
    private WindowController controller_;
    
    private final Adapter adapter_;

    /**
     * 
     */
    public SaveAction() {
        super();
        controller_ = null;
        adapter_ = new Adapter();
        setText(CLB_Name.get());
        setEnabled(false);
    }
    
	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}
	
    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public SaveAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	controller_ = controller;
    	controller_.addListener(adapter_);
    	return this;
    }

    
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.IAction#run()
     */
    @Override
	public void run() {
        if (controller_ == null) {
        	log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored."); //$NON-NLS-1$
            return;
        }
        
        // ۑOTextEditorȂǂ̕ҏWSăfɔfB
        // ̂߂Ɍ݂̃tH[JXU͂(ŕҏWCxg)
        // ēxtH[JXĂĂB
        Control focused = Display.getCurrent().getFocusControl();
        focused.getParent().forceFocus();
        focused.forceFocus();
        
        GameFrameController gfc = controller_.getActive();
        boolean overwritable = FileManager.instance().checkOverwritable(gfc.getCollection());
        if (!overwritable || Ios.isTemporaryFile(gfc.getCollection().getFile()))
        {
        	File newFile = IgoFileDialog.askSaveFile(gfc.getCollection());
        	if (newFile == null) {
        		return;
        	}
        	gfc.getCollection().setFile(newFile);
        }
        
	    try {
            FileManager.instance().save(gfc.getCollection());
            gfc.clearChangedFlag();
            
        } catch (YukinoshitaException e) {
        	gfc.getCollection().setFile(null);
            log_s_.error(BasicMessages.NT_FILE_SAVE_FAILURE.get(), e);
            MessageDialog.openError(
            		Display.getCurrent().getActiveShell(),
            		BasicMessages.NT_FILE_SAVE_FAILURE.get(),
                    e.getLocalizedMessage());
        }
    }
    
    /**
     * 
     */
    private class Adapter implements NodeMonitor, WindowControllerListener {
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    	private GameFrameController gfc_ = null;
		/**
		 * 
		 */
		private Adapter() {
			super();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			eventBroker_.removeView(SaveAction.this);
			if (now != null) {
				now.getEventBroker().addView(SaveAction.this);
				SaveAction.this.setEnabled(now.isChanged());
			} else {
				eventBroker_ = EventBroker.NULL_BROKER;
				SaveAction.this.setEnabled(false);
			}
			gfc_ = now;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			ArgumentChecker.throwIfNull(nodeView);
			SaveAction.this.setEnabled(gfc_.isChanged());
		}
    }
}
