/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SaveAsAction extends Action implements Adaptable {

    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(SaveAsAction.class);

    
    /** Otĕۑ(&A)... */
    static private final MessageResource CLB_Name 
    		= new MessageResource(SaveAsAction.class, "clbName"); //$NON-NLS-1$

	/**
     * ANVsΏۂ̃Rg[[łB 
     */
    private WindowController controller_;
    
    private final Adapter adapter_;
    
    /**
	 * 
	 */
	public SaveAsAction() {
		super();
        controller_ = null;
        adapter_ = new Adapter();
        setText(CLB_Name.get());
        setEnabled(false);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public SaveAsAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	controller_ = controller;
    	controller_.addListener(adapter_);
    	return this;
    }
 
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.IAction#run()
     */
    @Override
	public void run() {
        if (controller_ == null) {
        	log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored."); //$NON-NLS-1$
            return;
        }
        // ۑOTextEditorȂǂ̕ҏWSăfɔfB
        // ̂߂Ɍ݂̃tH[JXU͂(ŕҏWCxg)
        // ēxtH[JXĂĂB
        Control focused = Display.getCurrent().getFocusControl();
        focused.getParent().forceFocus();
        focused.forceFocus();

        GameFrameController gfc = controller_.getActive();
    	File file = IgoFileDialog.askSaveFile(gfc.getCollection());
    	if (file == null) {
    		return;
    	}

    	// {[hłʖۑ͉\Ȃ̂
    	// ChahgeFileNameR}hgĂ܂(UndołĂ܂̂)B
    	// ̂ߒڕҏWĂB
    	controller_.getActive().getCollection().setFile(file);
   	        
	    try {
            FileManager.instance().save(gfc.getCollection());
            gfc.clearChangedFlag();
        } catch (YukinoshitaException e) {
            log_s_.error(BasicMessages.NT_FILE_SAVE_FAILURE.get(), e);
            MessageDialog.openError(
            		Display.getCurrent().getActiveShell(),
                    BasicMessages.NT_FILE_SAVE_FAILURE.get(), 
                    e.getLocalizedMessage());
        }
    }
    
    /**
     * 
     */
    private class Adapter implements WindowControllerListener {
    	
		/**
		 * 
		 */
		private Adapter() {
			super();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			SaveAsAction.this.setEnabled(now != null);
		}
    }
}
