/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.view.WindowController;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SaveLayoutAction extends AbstractAction implements Adaptable {

    private final Adapter adapter_;
    
    /**
	 * @param controller
	 */
	public SaveLayoutAction(WindowController controller) {
		super(controller);
		adapter_ = new Adapter();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}

/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		controller_.saveLayout();
	}

    /**
     * 
     */
    private class Adapter {
    	// ɃA_v^[͎gĂȂ
    }
}
