/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/**
 * voC_[IANVłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SelectProviderAction<T extends Provider> extends Action implements Adaptable {
	/** ̃NX̃K[łB */
	static private final Log log_s_ = LogFactory.getLog(SelectProviderAction.class);

	/**
	 * ̃ANVɂēo^voC_[łB
	 */
	private final T provider_;
	
	/**
	 * voC_[̃C^[tFCXłB
	 */
	private final Class<T> providerInterface_;

	/**
	 * ANVsΏۂ̃Rg[[łB
	 */
	private WindowController controller_;

	/**
	 *  
	 */
	private final Adapter adapter_;
	
	/**
	 * @throws org.unitarou.lang.NullArgumentException
	 *         null̏ꍇ
	 */
	public SelectProviderAction(Class<T> providerInterface, T provider) {
		super(Strings.EMPTY, IAction.AS_RADIO_BUTTON);
		ArgumentChecker.throwIfNull(providerInterface, provider);
		
		if (!providerInterface.isAssignableFrom(provider.getClass())) {
			throw new IllegalArgumentException("provider: " + provider  //$NON-NLS-1$
					+ " must be subclass of " + providerInterface); //$NON-NLS-1$
		}
		adapter_ = new Adapter();
		providerInterface_ = providerInterface;
		provider_ = provider;
		setText(provider_.displayName());

		Object currentProvider = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class,	null);
		setChecked(provider.equals(currentProvider));
		setEnabled(false);
	}
	
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.IAction#run()
     */
    @Override
	public void run() {
        if (controller_ == null) {
        	log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored."); //$NON-NLS-1$
            return;
        }
        controller_.getActive().changeProvider(providerInterface_, provider_);
    }
    
    
	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }
	
    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public SelectProviderAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	if (controller_ != null) {
    		controller_.removListener(adapter_);
    	}
    	controller_ = controller;
    	controller_.addListener(adapter_);
        return this;
    }

    /**
     * 
     */
    private class Adapter implements 
    		WindowControllerListener, ControllerStatusMonitor {
    	private GameFrameController gfc_ = null;
    	
 
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			if (gfc_ != null) {
				gfc_.getEventBroker().removeView(SelectProviderAction.this);
			}
			gfc_ = now;
			updateEnableStatus();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			updateEnableStatus();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// ȂB
		}
		
		private void updateEnableStatus() {
			if (gfc_ == null) {
				setEnabled(false);
				
			} else {
				gfc_.getEventBroker().addView(SelectProviderAction.this);
				GameType gameType = gfc_.getCollectionEditor().getActiveGame().getGameType();
				setEnabled(gfc_.isEditMode() || !GameType.PROBLEM.equals(gameType));
			}
		}

    }
}
