/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.None;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * ̕](BM, TE, IT, DO)ݒ肷ANVłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SetMoveValueAction extends AbstractAction implements Adaptable {
	/**
	 * r̊֌WɂSProperty̏WłB
	 * ꂩZbgꂽꍇAȊOZbg܂B
	 */
	static private final Set<Property> exclusives_s_;
	
	
	static  {
		List<Property> list = new ArrayList<Property>(8);
		list.add(SgfId.TESUJI.makeProperty(SgfDouble.EMPHASIZED));
		list.add(SgfId.TESUJI.makeProperty(SgfDouble.NORMAL));
		list.add(SgfId.BAD_MOVE.makeProperty(SgfDouble.EMPHASIZED));
		list.add(SgfId.BAD_MOVE.makeProperty(SgfDouble.NORMAL));
		list.add(SgfId.INTERESTING.makeProperty(None.INSTANCE));
		list.add(SgfId.DOUBTFUL.makeProperty(None.INSTANCE));
		
		exclusives_s_ = Collections.unmodifiableSet(new HashSet<Property>(list));
	}
	
	/**
	 * g\px:ۂSGF{ǉȟ`ɂȂ܂B
	 * u{0}:{1}ǉv*/
	static private final MessageResource LB_ADD
			= new MessageResource(SetMoveValueAction.class, "lbAdd"); //$NON-NLS-1$
	/**
	 * g\px:ۂSGF{폜ȟ`ɂȂ܂B
	 * u{0}:{1}폜v
	 */
	static private final MessageResource LB_REMOVE
			= new MessageResource(SetMoveValueAction.class, "lbRemove"); //$NON-NLS-1$

	 /** uSč폜v*/
	static private final MessageResource CLB_NO_VALUE  
			= new MessageResource(SetMoveValueAction.class, "clbNoValue"); //$NON-NLS-1$	
	
	
	private final Adapter adapter_;
	private final Property property_;
	
	/**
	 * {@link org.eclipse.jface.action.Action#setText(java.lang.String)}p
	 * xvoC_łB
	 */
	private PropertyLabelProvider provider_;

	
	/**
	 * r̊֌WɂSProperty̏WłB
	 * ꂩZbgꂽꍇAȊOZbg܂B
	 */
	private final Property[] exclusives_;
	
	/**
	 * ݒڂĂ{@link org.unitarou.sgf.RootGameTree}
	 * {@link GameType}ێ܂B
	 */
	private GameType gameType_;
	
	
	/**
	 * ǉ[htrueɁA폜[hfalseɂȂ܂B
	 */
	private boolean isAddMode_;
	
	
	/**
	 * @param controller
	 */
	public SetMoveValueAction(WindowController controller, Property property) {
		super(controller);
		adapter_ = new Adapter();
		property_ = (property == null) ? null : new Property(property);
		provider_ = new BasicPropertyLabelProvider();
		gameType_ = GameType.GAME;
		
		Set<Property> set = new HashSet<Property>(exclusives_s_);
		if (property_ == null) { 
			isAddMode_ = false;
			
		} else {
			isAddMode_ = true;
			if (!set.remove(property_)) {
				// 폜^[QbgꍇAOXg͋
				set.clear();
				
			} else if (property_.sgfId().valueType().equals(ValueType.DOUBLE)) {
				set.remove(property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
				set.remove(property_.sgfId().makeProperty(SgfDouble.NORMAL));
			}
		}
		exclusives_ = set.toArray(new Property[set.size()]);
		updateText();
		setEnabled(false);
		controller_.addListener(adapter_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		UpdateProperty command;
		if (isAddMode_ || property_ == null) { 
			command = new UpdateProperty(exclusives_, property_, null);
		} else {
			command = new UpdateProperty(new Property[]{property_}, null, null);
		}
		controller_.getActive().getEventBroker().executeCommand(command);
	}
	
	/**
	 * CX^X̓Ԃɍ킹ActionTextXV܂B<br>
	 */
	private void updateText() {
		if (property_ == null) {
			setText(CLB_NO_VALUE.get());
			return;
		}
		setText(isAddMode_ 
				? LB_ADD.get(property_.toSgf(), provider_.getLabel(gameType_, property_))
				: LB_REMOVE.get(property_.toSgf(), provider_.getLabel(gameType_, property_)));
	}

	
	/**
     */
    private class Adapter 
    		implements GameMonitor, NodeMonitor, ControllerStatusMonitor, WindowControllerListener 
    {
    	/**
    	 * ȑO{@link #changeActive(GameFrameController)}
    	 * w肳ꂽCX^XQƂŕێ܂B
    	 */
    	private Reference<GameFrameController> refGfc_;
    	
    	/**
    	 * ݂{@link NodeView}ɒ{@link SgfId}ꍇtrueɂȂ܂B
    	 */
    	private boolean hasMove_;

    	/**
		 * 
		 */
		private Adapter() {
			super();
			refGfc_ = new WeakReference<GameFrameController>(null);
			hasMove_ = false;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(SetMoveValueAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			
			if (now != null) {
				now.getEventBroker().addView(SetMoveValueAction.this);
				gameType_ = now.getCollectionEditor().getActiveGame().getGameType();
			}
			update();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			ArgumentChecker.throwIfNull(gameMediator);
			gameType_ = gameMediator.getGameType();
			update();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			ArgumentChecker.throwIfNull(nodeView);
			hasMove_ = nodeView.containsPropertyType(PropertyType.MOVE);
			boolean enableClear = false;
			if (property_ == null) {
				isAddMode_ = false;
				for (Property property : exclusives_) {
					if (null != nodeView.getProperty(property.sgfId())) {
						enableClear = true;
						break;
					}
				}
				setEnabled(hasMove_ && enableClear);
				return;
			}
			Property property = nodeView.getProperty(property_.sgfId());
			isAddMode_ = ((property == null) 
							|| !property.getString().equals(property_.getString()));
			update();
			if (!isEnabled()) {
				return;
			}
			//TODO ̂肩
			// l̏ꍇAԂ`FbNĔȂ獕ԁAȂ甒Ԃ̂
			// enableɂB
		}

		/**
		 * ݂{@link SetPositionValueAction#gameType_}ɂ킹
		 * ANVEnable/DisableƃxXV܂B 
		 */
		private void update() {
			EnumSet<GameType> gameTypes;
			if (property_ == null) {
				gameTypes = EnumSet.of(gameType_);
				
			} else {
				gameTypes = property_.sgfId().gameTypes();
			}

			GameFrameController gfc = refGfc_.get();
			setEnabled(hasMove_ && gfc != null && gfc.isEditMode() && gameTypes.contains(gameType_));
			if (gameTypes.contains(gameType_)) {
				updateText();
			} else {
				setText(BasicMessages.LB_NOT_IN_SERVICE.get());
			}
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			GameFrameController gfc = refGfc_.get();
			currentChanged(gfc.getCollectionEditor()
					  .getActiveGame()
					  .getNodeList()
					  .getCurrentNodeView());
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}
    }
}
