/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.unitarou.lang.Objects;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * ǖʂ̕](GB, GW, DM, HO, UC)ݒ肷ANVłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SetPositionValueAction extends AbstractAction implements Adaptable {
	/**
	 * r̊֌WɂSProperty̏WłB
	 * ꂩZbgꂽꍇAȊOZbg܂B
	 */
	static private final Set<Property> exclusives_s_;
	
	
	static  {
		List<Property> list = new ArrayList<Property>(8);
		list.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED));
		list.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL));
		list.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED));
		list.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL));
		list.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED));
		list.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL));
		list.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED));
		list.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL));
		
		exclusives_s_ = Collections.unmodifiableSet(new HashSet<Property>(list));
	}
	
	
	/**
	 * g\px:ۂSGF{ǉȟ`ɂȂ܂B
	 * u{0}:{1}ǉv*/
	static private final MessageResource LB_ADD
			= new MessageResource(SetPositionValueAction.class, "lbAdd"); //$NON-NLS-1$
	/**
	 * g\px:ۂSGF{폜ȟ`ɂȂ܂B
	 * u{0}:{1}폜v
	 */
	static private final MessageResource LB_REMOVE
			= new MessageResource(SetPositionValueAction.class, "lbRemove"); //$NON-NLS-1$

	 /** uSč폜v*/
	static private final MessageResource CLB_NO_VALUE  
			= new MessageResource(SetPositionValueAction.class, "clbNoValue"); //$NON-NLS-1$


	private final Adapter adapter_;
	private final Property property_;
	
	/**
	 * {@link org.eclipse.jface.action.Action#setText(java.lang.String)}p
	 * xvoC_łB
	 */
	private PropertyLabelProvider provider_;

	
	/**
	 * r̊֌WɂSProperty̏WłB
	 * ꂩZbgꂽꍇAȊOZbg܂B
	 */
	private final Property[] exclusives_;
	
	/**
	 * ݒڂĂ{@link org.unitarou.sgf.RootGameTree}
	 * {@link GameType}ێ܂B
	 */
	private GameType gameType_;
	
	/**
	 * ǉ[htrueɁA폜[hfalseɂȂ܂B
	 */
	private boolean isAddMode_;
	
	/**
	 * (l̂)[U̐FێB
	 * lȊOł <code>null</code>
	 */
	private SgfColor playerColor_;

	
	/**
	 * @param controller
	 * @param property <code>null</code>w肵ꍇ
	 *         SăNA郁\bhɂȂ܂BB
	 * @param sgfDouble
	 * @throws IllegalArgumentException sgfIdnullȊOValueTypeDOUBLEȊOsgfDoublenull̏ꍇB
	 */
	public SetPositionValueAction(WindowController controller, Property property) {
		super(controller);
		adapter_ = new Adapter();
		property_ = (property == null) ? null : new Property(property);
		provider_ = new BasicPropertyLabelProvider();
		controller_.addListener(adapter_);
		gameType_ = GameType.GAME;
		
		Set<Property> set = new HashSet<Property>(exclusives_s_);
		if (property_ == null) { 
			isAddMode_ = false;
			setText(CLB_NO_VALUE.get());
			set.add(SgfId.HOTSPOT.makeProperty(SgfDouble.EMPHASIZED));
			set.add(SgfId.HOTSPOT.makeProperty(SgfDouble.NORMAL));
			
		} else {
			if (property_.sgfId().valueType() != ValueType.DOUBLE) {
				throw new IllegalArgumentException();
			}
			isAddMode_ = true;
			updateText();
			
			if (set.remove(property_)) {
				set.remove(property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
				set.remove(property_.sgfId().makeProperty(SgfDouble.NORMAL));
			} else {
				// 폜^[QbgꍇAOXg͋
				set.clear();
			}
		}
		exclusives_ = set.toArray(new Property[set.size()]);
		playerColor_ = null;
		setEnabled(false);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		UpdateProperty command;
		if (isAddMode_ || property_ == null) { 
			command = new UpdateProperty(exclusives_, property_, null);
		} else {
			command = new UpdateProperty(new Property[]{property_}, null, null);
		}
		controller_.getActive().getEventBroker().executeCommand(command);
	}
	
	/**
	 * CX^X̓Ԃɍ킹ActionTextXV܂B<br>
	 */
	private void updateText() {
		if (property_ == null) {
			setText(CLB_NO_VALUE.get());
			return;
		}
		setText(isAddMode_ 
				? LB_ADD.get(property_.toSgf(), provider_.getLabel(gameType_, property_))
				: LB_REMOVE.get(property_.toSgf(), provider_.getLabel(gameType_, property_)));
	}
	
	/**
     */
    private class Adapter 
    		implements GameMonitor, NodeMonitor, ControllerStatusMonitor, WindowControllerListener 
    {
    	/**
    	 * ȑO{@link #changeActive(GameFrameController)}
    	 * w肳ꂽCX^XQƂŕێ܂B
    	 */
    	private Reference<GameFrameController> refGfc_;
    	
		/**
		 * 
		 */
		private Adapter() {
			super();
			refGfc_ = new WeakReference<GameFrameController>(null);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(SetPositionValueAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			
			if (now != null) {
				now.getEventBroker().addView(SetPositionValueAction.this);
				gameType_ = now.getCollectionEditor().getActiveGame().getGameType();
			}
			update();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			ArgumentChecker.throwIfNull(gameMediator);
			gameType_ = gameMediator.getGameType();
			currentChanged(gameMediator.getCurrentNodeView());
		}
		
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			ArgumentChecker.throwIfNull(nodeView);
			if (property_ == null) {
				isAddMode_ = false;
				setEnabled(false);
				for (Property property : exclusives_) {
					if (null != nodeView.getProperty(property.sgfId())) {
						setEnabled(true);
					}
				}
				return;
			}
			Property property = nodeView.getProperty(property_.sgfId());
			isAddMode_ = ((property == null) 
							|| !property.getString().equals(property_.getString()));
			
			if (!GameType.PROBLEM.equals(gameType_)) {
				playerColor_ = null;
				update();
				return;
			}

			// ŏ̒̐FTB
			// COLORƂ̃vpeBCOLORǂ
			// xςKv邽߁B
			
			GameFrameController gfc = refGfc_.get();
			RootGameTree rgt = gfc.getCollectionEditor().getActiveGame().getRootGameTree();
			playerColor_ = BasicFinder.firstMove(rgt);
			if (playerColor_ != null) {
				update();
				return;
			}
			
			// ȂꍇPLTB
			Property pl = nodeView.findProperty(SgfId.PLAYER_TO_PLAY);
			if (pl != null) {
				playerColor_ = SgfColor.parseQuietly(pl.getString());
			}
			update();
		}

		/**
		 * ݂{@link SetPositionValueAction#gameType_}ɂ킹
		 * ANVEnable/DisableƃxXV܂B 
		 */
		private void update() {
			EnumSet<GameType> gameTypes;
			if (property_ == null) {
				gameTypes = EnumSet.of(gameType_);
				
			} else {
				gameTypes = property_.sgfId().gameTypes();
			}

			GameFrameController gfc = refGfc_.get();
			setEnabled(gfc != null && gfc.isEditMode() && gameTypes.contains(gameType_));
			if (!gameTypes.contains(gameType_)) {
				setText(BasicMessages.LB_NOT_IN_SERVICE.get());
				return;
			}
			
			if (property_ == null || !GameType.PROBLEM.equals(gameType_)) {
				updateText();
				return;
			}

			SgfColor propColor = SgfColor.getColor(property_.sgfId());
			if (!Objects.equalsIncludeNull(playerColor_, propColor)) {
				setText(BasicMessages.LB_NOT_IN_SERVICE.get());
				setEnabled(false);
				
			} else {
				updateText();
			}
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			GameFrameController gfc = refGfc_.get();
			currentChanged(gfc.getCollectionEditor()
					  .getActiveGame()
					  .getNodeList()
					  .getCurrentNodeView());
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ			
		}
    }
}
