/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.SgfTextDialog;

/**
 * Nbv{[h\t{ڕҏWӐ}eLXgGfB^J܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ShowSgfText extends AbstractAction implements Adaptable {

	/**
	 *  
	 */
	private final Adapter adapter_;
	
	
	/**
	 * @param controller
	 */
	public ShowSgfText(WindowController controller) {
		super(controller);
		setEnabled(false);
		adapter_ = new Adapter();
		controller.addListener(adapter_);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		CollectionEditor collectionEditor = controller_.getActive().getCollectionEditor();
	
        Shell shell =  
        	new Shell(Display.getCurrent().getActiveShell(), 
        	        	SWT.PRIMARY_MODAL | SWT.DIALOG_TRIM);
        SgfTextDialog dialog = new SgfTextDialog(
        		shell, 
        		collectionEditor.getCollection(), 
        		collectionEditor.getActiveGameIndex());
        dialog.open();
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

	/**
     * 
     */
    private class Adapter implements WindowControllerListener {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			setEnabled(now != null);
		}
    }
}
