/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;

import org.unitarou.cmd.CommandDriver.Status;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.UndoComamnd;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/**
 * ҏẂuɖ߂vANVłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class UndoAction extends Action implements Adaptable {

    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(UndoAction.class);
    
    /** ɖ߂ - {0}(&U)@Ctrl+Z */
    static private final MessageResource CLB_NAME 
    		= new MessageResource(UndoAction.class, "clbName"); //$NON-NLS-1$

	/**
	 *  
	 */
	private final Adapter adapter_;

	/**
	 * ANVsΏۂ̃Rg[[łB
	 */
	private WindowController controller_;

	/**
     * 
     */
    public UndoAction() {
        super();
        adapter_ = new Adapter();
        controller_ = null;
        setCommandName(Strings.EMPTY);
        setEnabled(false);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}

	/**
	 * UNDÕR}h(F[I12]̒ǉ)ݒ肵܂B
     * @param undoName
     */
    private void setCommandName(String undoName) {
        setText(CLB_NAME.get(undoName));
    }

    /**
     * R}hAł悤ɁAgԂ܂B
     */
    public UndoAction setController(WindowController controller) {
    	ArgumentChecker.throwIfNull(controller);
    	if (controller_ != null) {
    		controller_.removListener(adapter_);
    	}
    	controller_ = controller;
    	controller_.addListener(adapter_);
        return this;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.action.IAction#run()
     */
    @Override
	public void run() {
        if (controller_ == null) {
        	log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored."); //$NON-NLS-1$
            return;
        }
        
        GameFrameController gfc = controller_.getActive();
        UndoComamnd comamnd = new UndoComamnd();
        gfc.getEventBroker().executeCommand(comamnd);
        Status status =  gfc.getCollectionEditor().getActiveGame().getCommandDriverStatus();
        if (status.getExecutedCommand() instanceof Command4NodeList) {
        	gfc.updateByRedoUndo(((Command4NodeList)status.getExecutedCommand()).getInfluence());
        }
    }
    
    /**
     * 
     */
    private class Adapter 
    		implements CommandDriverMonitor, ControllerStatusMonitor, WindowControllerListener 
    {
    	/**
    	 * ȑO{@link #changeActive(GameFrameController)}
    	 * w肳ꂽCX^XQƂŕێ܂B
    	 */
    	private Reference<GameFrameController> refGfc_;
    	
		/**
		 * 
		 */
		private Adapter() {
			super();
			refGfc_ = new WeakReference<GameFrameController>(null);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.CommandDriverMonitor#commandExecuted(org.unitarou.cmd.CommandDriver.Status)
		 */
		public void commandExecuted(Status status) {
			ArgumentChecker.throwIfNull(status);
			GameFrameController gfc = refGfc_.get();
			if (gfc != null) {
		        setEnabled(gfc.isEditMode() && status.isUndoable());
		        setCommandName(status.getUndoName());
			}
			
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(UndoAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			
			if (now == null) {
	            setEnabled(false);
	            setCommandName(Strings.EMPTY);
	            return;
	        }
			now.getEventBroker().addView(UndoAction.this);
			Status status = now.getCollectionEditor().getActiveGame().getCommandDriverStatus();
	        setEnabled(now.isEditMode() && status.isUndoable());
	        setCommandName(status.getUndoName());
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			GameFrameController now = refGfc_.get();
			if (now == null) {
				log_s_.warn("Lost GameFraemController (BUG)"); //$NON-NLS-1$
				return;
			}
			if (isEditMode) {
				Status status = now.getCollectionEditor().getActiveGame().getCommandDriverStatus();
		        setEnabled(status.isUndoable());
		        setCommandName(status.getRedoName());
			} else {
	            setEnabled(false);
	            setCommandName(Strings.EMPTY);
			}
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ			
		}
    }
}
