/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.UnsetVwAtRoot;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class UnsetVwAtRootAction extends AbstractAction implements Adaptable  {

    private final Adapter adapter_;
  /**
	 * 
	 */
	public UnsetVwAtRootAction(WindowController controller) {
		super(controller);
		adapter_ = new Adapter();
		controller.addListener(adapter_);
		setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		controller_.getActive().getEventBroker().executeCommand(new UnsetVwAtRoot());
	}
	
	/**
     */
    private class Adapter implements ControllerStatusMonitor, WindowControllerListener {

    	/**
    	 * ȑO{@link #changeActive(GameFrameController)}
    	 * w肳ꂽCX^XQƂŕێ܂B
    	 */
    	private Reference<GameFrameController> refGfc_;
    	
		/**
		 * 
		 */
		private Adapter() {
			super();
			refGfc_ = new WeakReference<GameFrameController>(null);
		}


		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.WindowControllerListener#changeActive(org.unitarou.yukinoshita.view.jface.GameFrameController)
		 */
		public void changeActive(GameFrameController now) {
			GameFrameController last = refGfc_.get();
			if (last != null) {
				last.getEventBroker().removeView(UnsetVwAtRootAction.this);
			}
			refGfc_ = new WeakReference<GameFrameController>(now);
			
			if (now == null) {
	            setEnabled(false);
	        } else {
	            setEnabled(now.isEditMode());
				now.getEventBroker().addView(UnsetVwAtRootAction.this);
	        }
		}
		
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			setEnabled(isEditMode);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}

    }
}