/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.CommandFactory;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/**
 * {@link org.unitarou.yukinoshita.view.jface.ann.RootAnnotationPanel}
 * {@link org.unitarou.yukinoshita.view.jface.ann.GameAnnotationPanel}Ȃǂ
 * ʂ̋@\񋟂钊ۃNXłB@\ƂẮA
 * <ol>
 * <li>{@link org.unitarou.yukinoshita.events.EventBroker}̕ێƍXVɂ킹Xi[̓o^폜</li>
 * <li>SgfTypedatumw肵čXVʒm</li>
 * </ol>
 * Ȃǂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
abstract public class AnnotationPanel implements Adaptable {

    private final Adapter adapter_;
    private EventBroker eventBroker_; 

    /**
     * (`Monitor)ɂ郂f̕ύXʒmɊÂ
     * WidgetύXĂ鎞trueێtOłB
     * ltrue̊ԂWidget̕ύXfɒʒm
     * {@link #updateProperty(String, SgfId, NodeView)}ׂ͂Ė܂B
     */
    private boolean isModelUpdateMode_;

    /**
     * 
     */
    public AnnotationPanel() {
        super();
        adapter_ = new Adapter();
        eventBroker_ = EventBroker.NULL_BROKER;
        isModelUpdateMode_ = false;
    }

    /**
     * TuNX̃\bhI[o[Chۂ́A
     * Kễ\bhĂяoĂB
     * 
     * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }
    
    
    
    /**
     * (`Monitor)ɂ郂f̕ύXʒmɊÂ
     * WidgetύXĂ鎞trueێtOłB
     * ltrue̊ԂWidget̕ύXfɒʒm
     * {@link #updateProperty(String, SgfId, NodeView)}ׂ͂Ė܂B
     * 
	 * @return Returns the isModelUpdateMode.
	 */
    protected boolean isModelUpdateMode() {
		return isModelUpdateMode_;
	}

	/**
     * (`Monitor)ɂ郂f̕ύXʒmɊÂ
     * WidgetύXĂ鎞trueێtOłB
     * ltrue̊ԂWidget̕ύXfɒʒm
     * {@link #updateProperty(String, SgfId, NodeView)}ׂ͂Ė܂B
     * 
	 * @param isModelUpdateMode The isModelUpdateMode to set.
	 */
    protected void setModelUpdateMode(boolean isModelUpdateMode) {
		isModelUpdateMode_ = isModelUpdateMode;
	}

	/**
     * {@link #isModelUpdateMode()}trueԂԁA
     * {@link EventBroker}ւ̍XVʒm͑SĔj܂B
     * 
     * @param newDatum {@link Property#Property(SgfId, String)}ɒړn镶A󕶎̏ꍇ͍폜Ӗ܂B
     *                  <b>GXP[v͋֎~łB</b>
     * @param sgfType XVΏۂƂȂvpeB̌^
     * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
     */
    protected void updateProperty(String newDatum, SgfId sgfType, NodeView nodeView) {
    	if (isModelUpdateMode_) {
    		return;
    	}
    	UpdateProperty command 
    		= CommandFactory.createUpdateProperty(newDatum, sgfType, nodeView, true);
    	if (command != null) {
    		eventBroker_.executeCommand(command);
    	}
    }

    private class Adapter implements ModelEventNotifier{

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(AnnotationPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(AnnotationPanel.this);
        }
    }

}
