/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.nio.charset.Charset;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.sgf.SgfId;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class CharsetEditor extends Editor {

    private Combo combo_;
    private final ComboFocusLost comboFocusLost_;

    /**
     * 
     */
    CharsetEditor() {
        super();
        comboFocusLost_ = new ComboFocusLost();
    }

    /**
     * @param parent
     */
    public Control createContents(Composite parent) {
        combo_ = new Combo(parent, SWT.DROP_DOWN);
        Charset[] charsets 
        		= (Charset[])Yukinoshita.context().getAttribute(Context.KEY_CHARSETS, null);
        for (int i = 0; i < charsets.length; ++i) {
            combo_.add(charsets[i].name());
        }
        combo_.select(0);
        combo_.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        combo_.setData(SgfId.CHARSET);
        combo_.addFocusListener(comboFocusLost_);
        return combo_;
    }

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	/**
     * @param isEditMode
     */
    void setEditable(boolean isEditMode) {
        combo_.setEnabled(isEditMode);
    }

    /**
     * @param string
     */
    void setText(String text) {
        combo_.deselectAll();
        combo_.setText(text);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.ann.Editor#getDatum()
     */
    @Override String getDatum() {
        return combo_.getText();
    }

    private class ComboFocusLost extends FocusAdapter {
        @Override
		public void focusLost(FocusEvent e) {
            fireModifyText(e.widget);
        }
    }
}
