/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

import org.unitarou.swt.ListenerList;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/**
 * SGF̊evpeBҏWEBWbgpAbstractNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
abstract class Editor implements WidgetContainer {

    private final ListenerList<ModifyListener> listenerList_;
    /**
     * 
     */
    Editor() {
        super();
        listenerList_ = new ListenerList<ModifyListener>(ModifyListener.class);
    }

    /** 
     * ύX(ҏWɃtH[JXOꂽiK)ŌĂяo郊Xi[o^܂B
     */
    void addModifyListener(ModifyListener listener) {
        ArgumentChecker.throwIfNull(listener);
        listenerList_.add(listener);
    }

    void removeModifyListener(ModifyListener listener) {
        ArgumentChecker.throwIfNull(listener);
        listenerList_.remove(listener);
    }
    
    protected void fireModifyText(Widget widget) {
        ArgumentChecker.throwIfNull(widget);
        
        Event event = new Event();
        event.widget = widget;
        ModifyEvent modifyEvent = new ModifyEvent(event);
        for (ModifyListener listener : listenerList_.getListeners()) {
        	listener.modifyText(modifyEvent);
        }
    }

    protected void fireModifyText(Widget widget, Object data) {
        ArgumentChecker.throwIfNull(data);
        
        Event event = new Event();
        event.widget = widget;
        event.data = data;
        ModifyEvent modifyEvent = new ModifyEvent(event);
        for (ModifyListener listener : listenerList_.getListeners()) {
        	listener.modifyText(modifyEvent);
        }
    }

    /**
     * SGFValue`̕Ԃ܂B
     */
    abstract String getDatum();
}
