/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/**
 * GameInfovpeB̕ҏWsۂ̋ʃplłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GameAnnotationPanel extends AnnotationPanel implements WidgetContainer {
	
    /** 
     * GameInfoɕނProperty̒ŁA
     * {@link org.unitarou.sgf.ValueType#SIMPLE_TEXT}
     * ƕނ^̔złB
     */
    static private final SgfId[] TYPE_SIMPLE_TEXT 
			= new SgfId[]{SgfId.GAME_NAME, 
							SgfId.PLAYER_WHITE, SgfId.WHITE_RANK, SgfId.WHITE_TEAM,
							SgfId.PLAYER_BLACK, SgfId.BLACK_RANK, SgfId.BLACK_TEAM,
							SgfId.DATE, SgfId.EVENT, SgfId.ROUND, SgfId.PLACE,
							SgfId.RULES, SgfId.OVERTIME, SgfId.USER, SgfId.SOURCE,
							SgfId.COPYRIGHT, SgfId.ANNOTATION, SgfId.OPENING};

    
    /** 
     * GameInfoɕނProperty̒ŁA
     * {@link org.unitarou.sgf.ValueType#REAL}܂{@link org.unitarou.sgf.ValueType#NUMBER}
     * ƕނ^̔złB
     */
    static private final SgfId[] TYPE_SPINNER 
    		= new SgfId[]{SgfId.HANDICAP, SgfId.KOMI, SgfId.TIMELIMIT};

    
    private GameType gameType_;

    private Composite group_;
    
    
    /** 
     * ^[{@link SgfId}, {@link Control}]
     * evpeBɑΉGfB^[Ă܂B
     * key{@link GameAnnotationPanel#TYPE_SIMPLE_TEXT}̏ꍇ{@link Text}Ă܂B 
     * key{@link GameAnnotationPanel#TYPE_SPINNER}̏ꍇ{@link Spinner}Ă܂B
     */
    private final Map<SgfId, Object> widgetMap_;
    
    private final Adapter adapter_;
    
    private final TextListener textListener_;
    private final SpinnerModifyListened spinnerModifyListened_;
    private final ResultModifyListened resultModifyListened_;
    
    
    /** ݑIĂ{@link NodeView}łB*/
    private NodeView nodeView_;
    
    /**
     * ݂̃Rg[̕ҏW[hێ܂B
     */
    private boolean isEditMode_;
    
    /**
     * 
     * @param gameType ̃plΏۂƂGMB̒lɂăpl̒gωB
     * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
     */
    public GameAnnotationPanel(GameType gameType) {
        super();
        gameType_ = gameType;
        ArgumentChecker.throwIfNull(gameType);
        widgetMap_ = new HashMap<SgfId, Object>();
        adapter_ = new Adapter();
        textListener_ = new TextListener();
        spinnerModifyListened_ = new SpinnerModifyListened();
        resultModifyListened_ = new ResultModifyListened();
        isEditMode_ = false;
    }
    
    
    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    @Override
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        Object ret = super.getAdapter(adapter);
        if (ret != null) {
            return ret;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        group_ = new Composite(parent, SWT.NONE);
        group_.setLayout(new FillLayout());

        ScrolledComposite sc = new ScrolledComposite(group_, SWT.V_SCROLL);
        sc.setLayout(new FillLayout());
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(false);
        Composite composite;
        if (gameType_.equals(GameType.PROBLEM)) {
        	composite = createProblemContents(sc);
        	
        } else if (gameType_.equals(GameType.DRILL)) {
        	composite = createDrillContents(sc);
        	
        } else {
        	composite = createGameContents(sc);
        }
        composite.pack();
        sc.setContent(composite);
        sc.setMinSize(composite.getSize());
        adapter_.setEditMode(isEditMode_);
        return group_;
    }
    
    private Composite createGameContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2, false));
        createSimpleTextEditor(composite, SgfId.GAME_NAME);
        createTextEditor(composite, SgfId.GAME_COMMENT);
        createSimpleTextEditor(composite, SgfId.PLAYER_WHITE);
        createSimpleTextEditor(composite, SgfId.WHITE_RANK);
        createSimpleTextEditor(composite, SgfId.WHITE_TEAM);
        createSimpleTextEditor(composite, SgfId.PLAYER_BLACK);
        createSimpleTextEditor(composite, SgfId.BLACK_RANK);
        createSimpleTextEditor(composite, SgfId.BLACK_TEAM);
        createHandicapEditor(composite);
        createResultEditor(composite);
        createSimpleTextEditor(composite, SgfId.DATE);
        createSimpleTextEditor(composite, SgfId.EVENT);
        createSimpleTextEditor(composite, SgfId.ROUND);
        createSimpleTextEditor(composite, SgfId.PLACE);
        createSimpleTextEditor(composite, SgfId.RULES);
        //TODO TIME_LIMITɂĂ͎bʁXɎwł镡SpinnerȂWidget삷B
        createReal(composite, SgfId.TIMELIMIT, 0, 99999999, 0, 1, 60);
        createSimpleTextEditor(composite, SgfId.OVERTIME);
        createSimpleTextEditor(composite, SgfId.USER);
        createSimpleTextEditor(composite, SgfId.SOURCE);
        createSimpleTextEditor(composite, SgfId.COPYRIGHT);
        createSimpleTextEditor(composite, SgfId.ANNOTATION);
        createSimpleTextEditor(composite, SgfId.OPENING);
        return composite;
    }
    
    private Composite createProblemContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2, false));
        createSimpleTextEditor(composite, SgfId.GAME_NAME);
        createResultEditor(composite);
        createSimpleTextEditor(composite, SgfId.BLACK_RANK);
        //TODO TIME_LIMITɂĂ͎bʁXɎwł镡SpinnerȂWidget삷B
        createReal(composite, SgfId.TIMELIMIT, 0, 99999999, 0, 1, 60);
        createTextEditor(composite, SgfId.GAME_COMMENT);
        createSimpleTextEditor(composite, SgfId.DATE);
        createSimpleTextEditor(composite, SgfId.SOURCE);
        createSimpleTextEditor(composite, SgfId.USER);
        createSimpleTextEditor(composite, SgfId.COPYRIGHT);
        return composite;
    }
    
    private Composite createDrillContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2, false));
        createSimpleTextEditor(composite, SgfId.GAME_NAME);
        createSimpleTextEditor(composite, SgfId.BLACK_RANK);
        createTextEditor(composite, SgfId.GAME_COMMENT);
        return composite;
    }
    


    private Text createSimpleTextEditor(Composite parent, SgfId sgfType) {
		Label label = new Label(parent, SWT.RIGHT);
        label.setText(sgfType.displayName());
        GridData gridData = new GridData(GridData.END, GridData.CENTER, false, false);
        label.setLayoutData(gridData);

        Text text = new Text(parent, SWT.SINGLE | SWT.BORDER);
        gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
        text.setLayoutData(gridData);
        text.addFocusListener(textListener_);
        text.addModifyListener(textListener_);
        text.setData(sgfType);
        widgetMap_.put(sgfType, text);
        return text;
    }

    /**
     * @param composite
     * @param game_comment
     */
    private void createTextEditor(Composite parent, SgfId sgfType) {
    	Composite composite = new Composite(parent, SWT.NONE) ;
    	GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 5);
    	composite.setLayoutData(gridData);
    	GridLayout gridLayout = new GridLayout(1, false);
    	gridLayout.horizontalSpacing = 0;
    	gridLayout.marginHeight = 0;
    	gridLayout.marginWidth = 0;
    	gridLayout.verticalSpacing = 5;
    	composite.setLayout(gridLayout);
    	
        Label label = new Label(composite, SWT.NONE | SWT.RIGHT);
        label.setText(sgfType.displayName());
        gridData = new GridData(GridData.BEGINNING, GridData.BEGINNING, false, false);
        label.setLayoutData(gridData);

        Text text = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
        gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
        gridData.heightHint = label.computeSize(SWT.DEFAULT, SWT.DEFAULT).y * 10; // TODO ReLXgo
        text.setLayoutData(gridData);
        text.addFocusListener(textListener_);
        text.addModifyListener(textListener_);
        text.setData(sgfType);
        widgetMap_.put(sgfType, text);
    }
    
    /**
     * {@link RealEditor}`̃GfBbg{bNX쐬܂B
     * @param parent
     * @param sgfId
     * @param min
     * @param max
     * @param digits
     * @param inc
     * @param page
     */
    private void createReal(
    		Composite parent, SgfId sgfId, int min, int max, int digits, int inc, int page) 
    {
        Label label = new Label(parent, SWT.RIGHT);
        label.setText(sgfId.displayName());
        GridData gridData = new GridData(GridData.END, GridData.CENTER, false, false);
        label.setLayoutData(gridData);
        RealEditor realEditor = new RealEditor(sgfId, min, max, digits, inc, page);
        Control control = realEditor.createContents(parent);
        gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
        control.setLayoutData(gridData);
        realEditor.addModifyListener(spinnerModifyListened_);
        widgetMap_.put(sgfId, realEditor);
    }

    /**
     * u΂ƃR~ҏWpl쐬܂B
     */
    private void createHandicapEditor(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        composite.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout(gridLayout);
        
        createReal(composite, SgfId.HANDICAP, 0, 99, 0, 1, 5);
        createReal(composite, SgfId.KOMI, -999, 999, 1, 5, 10);
    }

    /**
     * ʂҏWpl쐬܂B
     */
    private void createResultEditor(Composite parent) {
        ResultEditor resultEditor = new ResultEditor();
        Control control = resultEditor.createContents(parent);
        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        control.setLayoutData(gridData);
        resultEditor.addModifyListener(resultModifyListened_);
        widgetMap_.put(SgfId.RESULT, resultEditor);
    }
    
    /**
     * ̃pl̍ŏʂ̃Rg[Ԃ܂B
     * @return ̃pl̍ŏʂ̃Rg[B
     *          {@link #createContents(Composite)}ĂяoOnullԂB
     */
    public Control getControl() {
    	return group_;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
    	// ȂB
    }



    /**
     * SGFTEXT, SIMPLETEXTn̍ڂŕҏWƂɌĂяo郊Xi[łB
     * ҏW`FbNsA
     * Kvł{@link AnnotationPanel#updateProperty(String, SgfId, NodeView)}
     * Ăяo܂B
     * ܂AXVRꂪ悤ɃtH[JXOꂽƂɂ͕KL\bhĂяo܂B
     */
    private class TextListener extends FocusAdapter implements ModifyListener {
    	
    	/**
    	 * XV({@link AnnotationPanel#updateProperty(String, SgfId, NodeView)}
    	 * Ăяoꂽ̕ҏWێ܂B 
    	 */
    	private final Map<Text, String> lastStringMap_;
    	
    	/**
    	 * 
    	 */
    	private TextListener() {
    		super();
    		lastStringMap_ = new HashMap<Text, String>();
    	}
    	
		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
		 */
		public void modifyText(ModifyEvent e) {
			Text text = (Text)e.widget;
			
			String lastText = lastStringMap_.get(text);
			if (lastText == null) {
				lastText = Strings.EMPTY;
			}
			int charLength = Yukinoshita.context().getCurrent(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE);
			String newText = text.getText();
			if (charLength <= Strings.calcDiffSize(lastText, newText)) {
	        	update(text);
			}
		}
		
        /* (non-Javadoc)
         * @see org.eclipse.swt.events.FocusListener#focusLost(org.eclipse.swt.events.FocusEvent)
         */
        @Override
		public void focusLost(FocusEvent e) {
        	update((Text)e.widget);
        }

        /**
         * {@link AnnotationPanel#updateProperty(String, SgfId, NodeView)}ĂяoāA
         * Widget̕ύXfɔf܂B
         * @param text
         */
        private void update(Text text) {
            if (!isEditMode_) {
                return;
            }
			
            String newText = text.getText();

            //textdataɂSgfTypeĂB
            SgfId sgfType = (SgfId)text.getData();
            updateProperty(newText, sgfType, nodeView_);
            lastStringMap_.put(text, newText);
		}
    }
    
    private class SpinnerModifyListened implements ModifyListener {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
		 */
		public void modifyText(ModifyEvent e) {
            if (!isEditMode_) {
                return;
            }
            RealEditor realEditor = (RealEditor)e.data;
            String newValue = realEditor.getDatum();
            SgfId sgfType = realEditor.getSgfId();
            updateProperty(newValue, sgfType, nodeView_);
		}
    }

    private class ResultModifyListened implements ModifyListener {
        /* (non-Javadoc)
         * @see org.eclipse.swt.events.ModifyListener77#modifyText(org.eclipse.swt.events.ModifyEvent)
         */
        public void modifyText(ModifyEvent e) {
            if (!isEditMode_) {
                return;
            }
            ResultEditor editor = (ResultEditor)widgetMap_.get(SgfId.RESULT);
            String newDatum = editor.getDatum();
            updateProperty(newDatum, SgfId.RESULT, nodeView_);
        }
    }
    
    private class Adapter 
    		implements GameMonitor, GameInfoNodeMonitor, ControllerStatusMonitor 
    {
    	
    	/**
    	 * gameMediatorGameType{@link GameAnnotationPanel#gameType_}
    	 * r邱ƂŁÃpl\Ă邩𔻒fāA
    	 * XV}܂B
    	 */
    	private boolean panelIsShown_ = true;

    	/* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
         */
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull(gameMediator);
            
            panelIsShown_ = gameMediator.getGameType().equals(gameType_);
            if (!panelIsShown_) {
            	return;
            }
            NodeView currentNodeView = gameMediator.getCurrentNodeView();
            if (nodeView_ == null) {
                nodeView_ = currentNodeView;
            }
            updateImpl(currentNodeView);
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor#gameInfoChanged(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void gameInfoChanged(NodeView nodeView) {
            if (!panelIsShown_) {
            	return;
            }
            nodeView_ = nodeView;
            updateImpl(nodeView_);
		}

		private void updateImpl(NodeView nodeView) {
        	setModelUpdateMode(true);
            updateText(nodeView);
            updateSimpleTexts(nodeView);
            updateSpinner(nodeView);
            updateResult(nodeView);
        	setModelUpdateMode(false);
        }
        
        private void updateText(NodeView nodeView) {
            SgfId[] texts = new SgfId[]{SgfId.GAME_COMMENT};
            for (int i = 0; i < texts.length; ++i) {
                Text text = (Text)widgetMap_.get(texts[i]);
                if (text == null) {
                	continue;
                }

                Property property = nodeView.findProperty(texts[i]);
                String simpleText = Strings.EMPTY;
                if (property != null) {
                    simpleText = property.getString();
                }
                if (!simpleText.equals(text.getText())) {
                    text.setText(simpleText);
                }
            }
        }

        private void updateSimpleTexts(NodeView nodeView) {
            for (int i = 0; i < TYPE_SIMPLE_TEXT.length; ++i) {
                Text text = (Text)widgetMap_.get(TYPE_SIMPLE_TEXT[i]);
                if (text == null) {
                	continue;
                }

                Property property = nodeView.findProperty(TYPE_SIMPLE_TEXT[i]);
                String simpleText = Strings.EMPTY;
                if (property != null) {
                    simpleText = property.getString();
                }
                if (!simpleText.equals(text.getText())) {
                    text.setText(simpleText);
                }
            }
        }

        private void updateSpinner(NodeView nodeView) {
            for (SgfId sgfId : TYPE_SPINNER) {
            	RealEditor realEditor = (RealEditor)widgetMap_.get(sgfId);
                if (realEditor == null) {
                	continue;
                }

                Property property = nodeView.findProperty(sgfId);
                if (property != null) {
                	realEditor.setProperty(property);
                }
            }
        }

        
        /**
         * @param nodeView
         */
        private void updateResult(NodeView nodeView) {
            ResultEditor resultEditor = (ResultEditor)widgetMap_.get(SgfId.RESULT);
            if (resultEditor != null) {
                resultEditor.setProperty(nodeView.findProperty(SgfId.RESULT));
            }
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            isEditMode_ = isEditMode;
            for (int i = 0; i < TYPE_SIMPLE_TEXT.length; ++i) {
                Text text =(Text)widgetMap_.get(TYPE_SIMPLE_TEXT[i]);
                if (text != null) {
                    text.setEditable(isEditMode_);
                }
            }
            
            for (SgfId sgfId : TYPE_SPINNER) {
            	RealEditor realEditor = (RealEditor)widgetMap_.get(sgfId);
            	if (realEditor != null) {
            		realEditor.setEditable(isEditMode_);
            	}
            }
            
            ResultEditor resultEditor = (ResultEditor)widgetMap_.get(SgfId.RESULT);
            if (resultEditor != null) {
                resultEditor.setEditable(isEditMode_);
            }
            Text text = (Text)widgetMap_.get(SgfId.GAME_COMMENT);
            if (text != null) {
                text.setEditable(isEditMode_);
            }
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerStatus(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase status) {
            // ȂB
        }
    }
}
