/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/**
 * vpeB̂AGameInfovpeB̕ҏWsplłB<br>
 * łR(pElpEWp)̂R̃pl܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class GameInfoAnnotationPanel implements Adaptable, WidgetContainer {

	/**
	 * {@link Adaptable}ŕԂA_v^[łB 
	 */
	private final Adapter adapter_;
	
	/**
	 * ̃pl̍ŏʂ̃t[łB
	 */
	private Composite frame_;
	
	/**
	 * pElpEWpɃpl؂ւ邽߁A
	 * {@link #frame_}ɐݒ肷郌CAEgCX^XێĂ܂B
	 */
	private StackLayout stackLayout_;
	
	/**
	 * pElpEWp̊epl{@link GameType}
	 * Zbgŕێ}bvłB
	 */
	private final Map<GameType, GameAnnotationPanel> panelMap_;
	
	/**
	 * 
	 */
	public GameInfoAnnotationPanel() {
		super();
		adapter_ = new Adapter();
		frame_ = null;
		stackLayout_ = new StackLayout();
		panelMap_ = new HashMap<GameType, GameAnnotationPanel>();
		panelMap_.put(GameType.GAME, new GameAnnotationPanel(GameType.GAME));
		panelMap_.put(GameType.PROBLEM, new GameAnnotationPanel(GameType.PROBLEM));
		panelMap_.put(GameType.DRILL, new GameAnnotationPanel(GameType.DRILL));
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		frame_ = new Composite(parent, SWT.NONE);
		frame_.setLayout(stackLayout_);
		for (GameAnnotationPanel panel : panelMap_.values()) {
			panel.createContents(frame_);
		}
		return frame_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		for (GameAnnotationPanel panel : panelMap_.values()) {
			panel.dispose();
		}
		panelMap_.clear();
	}

	/**
	 * ̃CX^X̃A_v^[NXłB 
	 */
	private class Adapter extends TieredModelEventNotifier implements GameMonitor {

		private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
		 */
		@Override
		protected Adaptable[] getAdaptables() {
			return panelMap_.values().toArray(new Adaptable[panelMap_.size()]);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		@Override
		public void setEventBroker(EventBroker eventBroker) {
			eventBroker_.removeView(GameInfoAnnotationPanel.this);
			eventBroker_ = eventBroker;
			eventBroker_.addView(GameInfoAnnotationPanel.this);
			super.setEventBroker(eventBroker);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			ArgumentChecker.throwIfNull(gameMediator);
			
			GameAnnotationPanel panel = panelMap_.get(gameMediator.getGameType());
			if (panel == null) {
				panel = panelMap_.get(GameType.GAME);
			}
			stackLayout_.topControl = panel.getControl();
			stackLayout_.topControl.getParent().layout();
		}
	}
}
