/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.USpinner;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;

/**
 * REALNUMBERҏW邽߂̃GfB^[łB<br>
 * SpinerTextd˂`ŁAProperty̒llƂ
 * ʂł鎞SpinnerAʂłȂText\܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class RealEditor extends Editor {

    private StackLayout stackLayout_;
    
    private USpinner spinner_;
    
    private Text text_;
    
    private final SgfId sgfId_;
    
    private final int min_;
    private final int max_;
    private final int digits_;
    private final int inc_;
    private final int page_;

    /**
	 * 
	 */
	RealEditor(SgfId sgfId, int min, int max, int digits, int inc, int page) {
		super();
		sgfId_ = sgfId;
		min_ = min;
		max_ = max;
		digits_ = digits;
		inc_ = inc;
		page_ = page;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
    	Composite frame = new Composite(parent, SWT.NONE);
        stackLayout_ = new StackLayout();
        frame.setLayout(stackLayout_);
        createSpinnerEditor(frame);
        createTextEditor(frame);
        stackLayout_.topControl = spinner_;
        return frame;	
    }

	/**
	 * @param frame
	 * @return
	 */
	private Control createSpinnerEditor(Composite parent) {
		spinner_ = new USpinner(parent, SWT.BORDER);
		spinner_.setMinimum(min_);
		spinner_.setMaximum(max_);
		spinner_.setDigits(digits_);
		spinner_.setIncrement(inc_);
        spinner_.setPageIncrement(page_);
        spinner_.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				fireModifyText(spinner_, RealEditor.this);
			}
        });
        return spinner_;
	}
	

	/**
	 * @param frame
	 * @return
	 */
	private Control createTextEditor(Composite frame) {
		text_ = new Text(frame, SWT.SINGLE | SWT.BORDER);
		text_.addFocusListener(new FocusAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.FocusAdapter#focusLost(org.eclipse.swt.events.FocusEvent)
			 */
			@Override
			public void focusLost(FocusEvent e) {
				fireModifyText(text_, RealEditor.this);
			}
		});
		return text_;
	}

	
	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// ݂͓ɏsv
	}

	/**
     * @param resultProperty
     */
    void setProperty(Property resultProperty) {
        if (resultProperty == null) {
        	stackLayout_.topControl = spinner_;
        	return;
        }
        
        String string = resultProperty.getString();
    	String oldString = (stackLayout_.topControl == text_) ? text_.getText() : spinner_.getText();
    	if (string.equals(oldString)) {
    		return;
    	}
        
        try {
        	double value = Double.parseDouble(string);
        	spinner_.setSelection((int)(value * Math.pow(10, spinner_.getDigits())));
        	stackLayout_.topControl = spinner_;
        	
        } catch (NumberFormatException ignore) {
        	text_.setText(string);
        	stackLayout_.topControl = text_;
        }
        stackLayout_.topControl.getParent().layout();
    }
    
	/**
     * @param isEditMode
     */
    void setEditable(boolean isEditMode) {
    	spinner_.setEnabled(isEditMode);
    	text_.setEditable(isEditMode);
    }
    
    /**
     * @return
     */
    SgfId getSgfId() {
    	return sgfId_;
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.ann.Editor#getDatum()
	 */
	@Override
	String getDatum() {
		if (stackLayout_.topControl == text_) {
			return text_.getText();
		}
        String newValue;
        if (spinner_.getDigits() == 0) {
        	newValue = String.valueOf(spinner_.getSelection());
        } else {
            double value = spinner_.getSelection() / Math.pow(10, spinner_.getDigits());
            newValue = String.valueOf(value);
        }
        return newValue;
	}
}
