/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Result;
import org.unitarou.sgf.type.Result.Archetype;
import org.unitarou.swt.EnumCombo;
import org.unitarou.swt.EnumCombo.Style;
import org.unitarou.yukinoshita.view.jface.util.UEnumCombo;

/**
 * RE^O̕ҏWpWidgetłB
 * W+,W+TimeȂǂ{@link org.unitarou.yukinoshita.view.jface.util.UEnumCombo}
 * W+2.52.5͂{@link org.eclipse.swt.widgets.Spinner}
 * \܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class ResultEditor extends Editor {

    private final EnumCombo<Result.Archetype> enumCombo_;
    
    private Spinner scoreEditor_;
    
    private final ComboFocusListened comboFocusListened_;
    
    private final ScoreModifyListened scoreModifyListened_;
    
    private final ComboModifyListened comboModifyListened_;
    
    /** ʂ̃R{{bNXW+B+̏ꍇtrueɂȂ܂B*/
    private boolean enableScore_;
    
    /**
     * ݂̌ʂێ܂B
     */
    private Result result_;
    
    /**
     * 
     */
    ResultEditor() {
        super();
        EnumSet<Result.Archetype> enumSet = EnumSet.allOf(Result.Archetype.class);
        enumSet.remove(Result.Archetype.OTHER);
        enumCombo_ = new EnumCombo<Result.Archetype>(enumSet, EnumSet.of(Style.PERMIT_NO_CHOICE));
        comboFocusListened_ = new ComboFocusListened();
        scoreModifyListened_ = new ScoreModifyListened();
        comboModifyListened_ = new ComboModifyListened();
        enableScore_ = false;
        result_ = new Result(Archetype.OTHER);
    }

    /**
     * parentGridLayoutOƂĂ܂B
     * {@link GridData#horizontalSpan}=2ɐݒ肵Ă܂B
     * @param parent
     * @see org.unitarou.swt.WidgetContainer#createontents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout(gridLayout);
        createResultCombo(composite);
        scoreEditor_ = new Spinner(composite, SWT.BORDER);
        scoreEditor_.addModifyListener(scoreModifyListened_);
        scoreEditor_.setEnabled(enableScore_);
        scoreEditor_.setDigits(1);
        scoreEditor_.setSelection(0);
        scoreEditor_.setMinimum(0);
        scoreEditor_.setMaximum(9999);
        scoreEditor_.setIncrement(5);
        scoreEditor_.setPageIncrement(10);
        return composite;
    }

    /**
     * {@link Result.Archetype}{@link UEnumCombo}쐬Ă܂B
     */
    private void createResultCombo(Composite parent) {
		Label label = new Label(parent, SWT.RIGHT);
        label.setText(SgfId.RESULT.displayName());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
        
        Combo combo = (Combo)enumCombo_.createContents(parent);
        combo.addFocusListener(comboFocusListened_);
        combo.addModifyListener(comboModifyListened_);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// Ȃ
	}

	/**
     * @param resultProperty
     */
    void setProperty(Property resultProperty) {
        if (resultProperty == null) {
        	result_ = new Result(Archetype.OTHER);
            enumCombo_.select(null);
            scoreEditor_.setSelection(0);
            return;
        }
        
        String text = resultProperty.getString();
    	result_ = Result.parse(text);
    	if (Archetype.OTHER.equals(result_.getArchetype())) {
            enumCombo_.setText(result_.getValue());
    	} else {
            enumCombo_.select(result_.getArchetype());
    	}
        scoreEditor_.setSelection((int)(result_.getScore() * 10));
    }

    /**
     * @param isEditMode
     */
    void setEditable(boolean isEditMode) {
        enumCombo_.setEnabled(isEditMode);
        scoreEditor_.setEnabled(isEditMode && enableScore_);
    }
    

    /**
     * SGFValue`̕Ԃ܂B
     */
    @Override 
    String getDatum() {
        Archetype archetype = enumCombo_.getSelected();
        if (Archetype.SCORED.contains(archetype) ) {
            return archetype.typeName() + String.valueOf(scoreEditor_.getSelection() / 10.0);
        } else if (archetype == null) {
            return enumCombo_.getText();
            
        }
        return archetype.typeName().toString();
    }
    
    private void updateScoreEditorEnabled() {
        Archetype archetype = enumCombo_.getSelected();
        if (Archetype.SCORED.contains(archetype) ) {
            enableScore_ = true;
        } else {
            enableScore_ = false;
            scoreEditor_.setSelection(0);
        }
        scoreEditor_.setEnabled(enumCombo_.isEnabled() && enableScore_);
    }
    
    private class ComboFocusListened extends FocusAdapter {
        @Override
		public void focusLost(FocusEvent e) {
            updateScoreEditorEnabled();
            fireModifyText(enumCombo_.getCombo());
        }
    }
    
    /**
     * {@link UEnumCombo}{@link Combo}ύXƂ
     * {@link ResultEditor#fireModifyText()}ĂяoƃXi[̖ĂяoɂȂ̂ŁA
     * {@link ResultEditor#scoreEditor_}enable/disablê݂𐧌䂵Ă܂B
     */
    private class ComboModifyListened implements ModifyListener {

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
         */
        public void modifyText(ModifyEvent e) {
            updateScoreEditorEnabled();
        }
    }

    /**
     * {@link ResultEditor#scoreEditor_}XVꂽꍇ́Â܂
     */
    private class ScoreModifyListened implements ModifyListener {
        /* (non-Javadoc)
         * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
         */
		public void modifyText(ModifyEvent e) {
			int intScore = (int)(result_.getScore() * 10);
			if (scoreEditor_.getSelection() != intScore) {
	            fireModifyText(enumCombo_.getCombo());
			}
        }
    }
}
