/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.swt.EnumCombo;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.util.UEnumCombo;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * vpeB̂ARootvpeB̕ҏWsplłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class RootAnnotationPanel extends AnnotationPanel implements WidgetContainer {

    /** uxȕҏWv*/
    static private final MessageResource CLB_EDIT_ADVANCED_TYPE
    		= new MessageResource(RootAnnotationPanel.class, "clbEditAdvancedType"); //$NON-NLS-1$
    
    /** 
     * {@link UEnumCombo}蓖Ă{@link SgfId}̔złB
     */
    static private final SgfId[] TYPE_ENUM 
    		= new SgfId[]{SgfId.GAME_MODE, SgfId.STYLE};
    
    /** 
     * ^[{@link SgfId}, {@link Control}{@link SizeEditor}]
     * evpeBɑΉGfB^[Ă܂B
     */
    private final Map<SgfId, Object> widgetMap_;

    private GameMediator gameMediator_;

    
    private Button chAdvancedEditMode_;

    private final Adapter adapter_;
    
    private boolean isEditMode_;
    
    private final ComboFocusLost comboFocusLost_;
    
    private final TextListener textListener_;
    
    private final ModifyListened modifyListened_;
    

    public RootAnnotationPanel() {
        super();
        widgetMap_ = new HashMap<SgfId, Object>();
        gameMediator_ = null;
        adapter_ = new Adapter();
        isEditMode_ = false;
        comboFocusLost_ = new ComboFocusLost();
        textListener_ = new TextListener();
        modifyListened_ = new ModifyListened();
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    @Override
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        Object ret = super.getAdapter(adapter);
        if (ret != null) {
            return ret;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2, false));
        createCbEditAdvancedType(composite);
        createApplicationEdit(composite);
        createCharset(composite);
        createEnumCombo2(composite, SgfId.FILE_FORMAT, EnumSet.allOf(FileFormat.class));
        createEnumCombo(composite, SgfId.GAME_MODE, GameMode.class);
        createEnumCombo2(composite, SgfId.GAME_TYPE, EnumSet.allOf(GameType.class));
        createEnumCombo(composite, SgfId.STYLE, Style.class);
        createSizeEditor(composite);
        adapter_.setEditMode(isEditMode_);
        composite.pack();
        return composite;
    }
    


    /**
     * ʂɂ͕ҏWȂ^OҏW邩ǂ
     * 肷`FbN{bNX쐬܂B
     */
    private void createCbEditAdvancedType(Composite parent) {
        chAdvancedEditMode_ = new Button(parent, SWT.CHECK | SWT.FLAT);
        chAdvancedEditMode_.setSelection(false);
        chAdvancedEditMode_.setText(CLB_EDIT_ADVANCED_TYPE.get());
        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        chAdvancedEditMode_.setLayoutData(gridData);
        chAdvancedEditMode_.addSelectionListener(new SelectionAdapter() {
            /* (non-Javadoc)
             * @see SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
			public void widgetSelected(SelectionEvent e) {
                setEnableAdvanced(((Button)e.widget).getSelection());
            }
        
        });
    }
    
    /**
     * @param selection
     */
    private void setEnableAdvanced(boolean enable) {
        Text text = (Text)widgetMap_.get(SgfId.APPLICATION);
        text.setEditable(enable && isEditMode_);
        
        
        EnumCombo<?> ec = (EnumCombo)widgetMap_.get(SgfId.FILE_FORMAT);
        ec.getCombo().setEnabled(enable && isEditMode_);

        
        UEnumCombo<?> uec = (UEnumCombo)widgetMap_.get(SgfId.GAME_MODE);
        uec.getCombo().setEnabled(enable && isEditMode_);
        
        SizeEditor sizeCombos = (SizeEditor)widgetMap_.get(SgfId.SIZE);
        sizeCombos.setAdvanced(enable);
    }

    private void createApplicationEdit(Composite parent) {
		Label label = new Label(parent, SWT.NONE | SWT.RIGHT);
        label.setText(SgfId.APPLICATION.displayName());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));

        Text text = new Text(parent, SWT.SINGLE | SWT.BORDER);
        text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        text.addFocusListener(textListener_);
        text.addModifyListener(textListener_);
        text.setData(SgfId.APPLICATION);
        widgetMap_.put(SgfId.APPLICATION, text);
    }
    
    private void createCharset(Composite parent) {
		Label label = new Label(parent, SWT.NONE | SWT.RIGHT);
        label.setText(SgfId.CHARSET.displayName());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
        
        CharsetEditor charsetEditor = new CharsetEditor();
        charsetEditor.createContents(parent);
        charsetEditor.addModifyListener(modifyListened_);
        widgetMap_.put(SgfId.CHARSET, charsetEditor);
    }
    

    private <T extends UEnum> 
    Combo createEnumCombo(Composite parent, SgfId sgfType, Class<T> enumClass) {
		Label label = new Label(parent, SWT.NONE | SWT.RIGHT);
        label.setText(sgfType.displayName());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));

        UEnumCombo<T> uenumCombo = new UEnumCombo<T>(enumClass);
        Combo combo = (Combo)uenumCombo.createContents(parent);
        combo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        combo.addFocusListener(comboFocusLost_);
        combo.setData(sgfType);
        widgetMap_.put(sgfType, uenumCombo);
        return combo;
    }
    
    private <T extends Enum<T>> 
    Combo createEnumCombo2(Composite parent, SgfId sgfType, EnumSet<T> values) {
		Label label = new Label(parent, SWT.NONE | SWT.RIGHT);
        label.setText(sgfType.displayName());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));

        EnumCombo<T> enumCombo = new EnumCombo<T>(values);
        Combo combo = (Combo)enumCombo.createContents(parent);
        combo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        combo.addFocusListener(comboFocusLost_);
        combo.setData(sgfType);
        widgetMap_.put(sgfType, enumCombo);
        return combo;
    }
    
    private void createSizeEditor(Composite parent) {
		Label label = new Label(parent, SWT.NONE | SWT.RIGHT);
        label.setText(SgfId.SIZE.displayName());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));

        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        SizeEditor sizeEditor = new SizeEditor();
        Control control = sizeEditor.createContents(parent);
        sizeEditor.addModifyListener(modifyListened_);
        control.setLayoutData(gridData);
        
        widgetMap_.put(SgfId.SIZE, sizeEditor);
    }
   
    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        //
    }
    
    private NodeView getRootNodeView() {
        if (gameMediator_ == null) {
            throw new IllegalStateException();
        }
        return gameMediator_.getNodeList().getNodeView(0); 
    }


    private class Adapter
    		implements GameMonitor, NodeMonitor, ControllerStatusMonitor {

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
         */
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull(gameMediator);
            gameMediator_ = gameMediator;
            updateImpl();
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
         */
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull(nodeView);
            updateImpl();
        }

        private void updateImpl() {
        	setModelUpdateMode(true);
            NodeView rootNodeView = getRootNodeView();
            Property property;
            
            //AP^O̍XV
            property = rootNodeView.getProperty(SgfId.APPLICATION);
            Text text = (Text)widgetMap_.get(SgfId.APPLICATION);
            text.setText((property != null) ? property.getString() : Strings.EMPTY);

            //CA^O̍XV
            property = rootNodeView.getProperty(SgfId.CHARSET);
            CharsetEditor charsetEditor = (CharsetEditor)widgetMap_.get(SgfId.CHARSET);
            charsetEditor.setText((property != null) ? property.getString() : Strings.EMPTY);
            
            //FF^O̍XV
            property = rootNodeView.getProperty(SgfId.FILE_FORMAT);
            EnumCombo<FileFormat> ecff = (EnumCombo)widgetMap_.get(SgfId.FILE_FORMAT);
            FileFormat fileFormat = null;
            if (property != null) {
                try {
                    fileFormat = FileFormat.parse(property.getString());
                } catch (TypeParseException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
            ecff.select(fileFormat);
            
            //GM^O̍XV
            property = rootNodeView.getProperty(SgfId.GAME_MODE);
            UEnumCombo uec = (UEnumCombo)widgetMap_.get(SgfId.GAME_MODE);
            uec = (UEnumCombo)widgetMap_.get(SgfId.GAME_MODE);
            GameMode gameMode = null;
            if (property != null) {
                gameMode = GameMode.parse(property.getString());
            }
            uec.select(gameMode);

            //GT^O̍XV
            property = rootNodeView.getProperty(SgfId.GAME_TYPE);
            EnumCombo<GameType> ec = (EnumCombo)widgetMap_.get(SgfId.GAME_TYPE);
            GameType gameType = null;
            if (property != null) {
                try {
                    gameType = GameType.parse(property.getString());
                } catch (TypeParseException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
            ec.select(gameType);

            //ST^O̍XV
            property = rootNodeView.getProperty(SgfId.STYLE);
            uec = (UEnumCombo)widgetMap_.get(SgfId.STYLE);
            Style style = null;
            if (property != null) {
                style = Style.parse(property.getString());
            }
            uec.select(style);

            //SZ^O̍XV
            property = rootNodeView.getProperty(SgfId.SIZE);
            SizeEditor sizeEditor = (SizeEditor)widgetMap_.get(SgfId.SIZE);
            SgfSize sgfSize = SgfSize.DEFAULT;
            if (property != null) {
                try {
                    sgfSize = SgfSize.parse(property.getString());
                } catch (TypeParseException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
            sizeEditor.select(sgfSize);
        	setModelUpdateMode(false);
        }


        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            isEditMode_ = isEditMode;
            for (int i = 0; i < TYPE_ENUM.length; ++i) {
                UEnumCombo enumCombo = (UEnumCombo)widgetMap_.get(TYPE_ENUM[i]);
                enumCombo.setEditable(isEditMode);
            }
            
            EnumCombo<?> ec = (EnumCombo)widgetMap_.get(SgfId.FILE_FORMAT);
            ec.getCombo().setEnabled(isEditMode);
            
            ec = (EnumCombo)widgetMap_.get(SgfId.GAME_TYPE);
            ec.getCombo().setEnabled(isEditMode);

            Text text = (Text)widgetMap_.get(SgfId.APPLICATION);
            text.setEditable(isEditMode);
            
            SizeEditor sizeEditor = (SizeEditor)widgetMap_.get(SgfId.SIZE);
            sizeEditor.setEditable(isEditMode);
            
            CharsetEditor charsetEditor = (CharsetEditor)widgetMap_.get(SgfId.CHARSET);
            charsetEditor.setEditable(isEditMode);
            
            setEnableAdvanced(chAdvancedEditMode_.getSelection());
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerStatus(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase status) {
            // Ȃ
        }	
    }

    /**
     * {@link UEnumCombo}{@link EnumCombo}̍ڂtH[JXOꂽƂ
     * Ăяo郊Xi[łB<br>
     * ҏW`FbNsA
     * Kvł{@link AnnotationPanel#updateProperty(String, SgfId, NodeView)}
     * Ăяo܂B
     */
    private class ComboFocusLost extends FocusAdapter { 
        @Override
		public void focusLost(FocusEvent e) {
            if (!isEditMode_) {
                return;
            }
            Combo combo = (Combo)e.widget;
            //combodataɂSgfTypeĂB
            SgfId sgfType = (SgfId)combo.getData();
            Object obj = widgetMap_.get(sgfType);
            String newDatum = null;
            if (obj instanceof UEnumCombo<?>) {
            	UEnumCombo<?> enumCombo = (UEnumCombo)widgetMap_.get(sgfType);
            	newDatum = enumCombo.getSelectedDatum();
            } else if (obj instanceof EnumCombo<?>) {
            	EnumCombo<?> enumCombo = (EnumCombo)widgetMap_.get(sgfType);
            	Object selected = enumCombo.getSelected();
            	TypedString<?> typedString = (TypedString)selected;
            	newDatum = (typedString != null) ? typedString.getString() : Strings.EMPTY;
            }
            
            updateProperty(newDatum, sgfType, getRootNodeView());
        }
    }

    /**
     * SGFTEXT, SIMPLETEXTn̍ڂŕҏWƂɌĂяo郊Xi[łB
     * ҏW`FbNsA
     * Kvł{@link AnnotationPanel#updateProperty(String, SgfId, NodeView)}
     * Ăяo܂B
     * ܂AXVRꂪ悤ɃtH[JXOꂽƂɂ͕KL\bhĂяo܂B
     */
    private class TextListener extends FocusAdapter implements ModifyListener {
    	
    	/**
    	 * XV({@link AnnotationPanel#updateProperty(String, SgfId, NodeView)}
    	 * Ăяoꂽ̕ҏWێ܂B 
    	 */
    	private final Map<Text, String> lastStringMap_;
    	
    	/**
    	 * 
    	 */
    	private TextListener() {
    		super();
    		lastStringMap_ = new HashMap<Text, String>();
    	}
    	
		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
		 */
		public void modifyText(ModifyEvent e) {
			Text text = (Text)e.widget;
			
			String lastText = lastStringMap_.get(text);
			if (lastText == null) {
				lastText = Strings.EMPTY;
			}
			int charLength = Yukinoshita.context().getCurrent(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE);
			String newText = text.getText();
			if (charLength <= Strings.calcDiffSize(lastText, newText)) {
	        	update(text);
			}
		}
		
        /* (non-Javadoc)
         * @see org.eclipse.swt.events.FocusListener#focusLost(org.eclipse.swt.events.FocusEvent)
         */
        @Override
		public void focusLost(FocusEvent e) {
        	update((Text)e.widget);
        }

        private void update(Text text) {
            if (!isEditMode_) {
                return;
            }
			
            String newText = text.getText();

            //textdataɂSgfTypeĂB
            SgfId sgfType = (SgfId)text.getData();
            updateProperty(newText, sgfType, getRootNodeView());
            lastStringMap_.put(text, newText);
		}
    }

    private class ModifyListened implements ModifyListener {

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
         */
        public void modifyText(ModifyEvent e) {
            SgfId sgfType = (SgfId)e.widget.getData();
            String newDatum = ((Editor)widgetMap_.get(sgfType)).getDatum();
            updateProperty(newDatum, sgfType, getRootNodeView());
        }
    }
}
